/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.annotation.CombatAttributesInfo;
import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.graphics.animation.CreatureAnimationController;
import de.gurkenlabs.litiengine.physics.MovementController;
import java.awt.geom.Point2D;
import java.util.Random;

@CombatAttributesInfo(health=1)
public class DecorMob
extends Creature {
    private final MovementBehavior movementBehaviour;
    private final String mobType;

    public DecorMob(Point2D location, String mobType, MovementBehavior behaviour, short velocity) {
        this.mobType = mobType;
        this.setLocation(location);
        this.setSpritePrefix("decormob-" + this.getMobType().toLowerCase());
        Game.getEntityControllerManager().addController(this, new CreatureAnimationController<DecorMob>(this, true));
        this.movementBehaviour = behaviour;
        switch (this.movementBehaviour) {
            case SHY: {
                Game.getEntityControllerManager().addController(this, new ShyDecorMobMovementController(this));
                break;
            }
            case RANDOM: {
                break;
            }
        }
        this.setVelocity(velocity);
    }

    public String getMobType() {
        return this.mobType;
    }

    public MovementBehavior getMovementBehavior() {
        return this.movementBehaviour;
    }

    private class ShyDecorMobMovementController
    extends MovementController<DecorMob> {
        private int angle;
        private long lastAngleChange;
        private long nextAngleChange;

        public ShyDecorMobMovementController(DecorMob decorMob2) {
            super(decorMob2);
            this.calculateNextAngleChange();
        }

        public void calculateNextAngleChange() {
            this.nextAngleChange = (long)new Random().nextInt(3000) + 2000L;
        }

        @Override
        public void update() {
            super.update();
            if (Game.getEnvironment() == null || DecorMob.this.isDead()) {
                return;
            }
            long currentTick = Game.getLoop().getTicks();
            long timeSinceLastAngleChange = Game.getLoop().getDeltaTime(this.lastAngleChange);
            if (this.angle == 0 || timeSinceLastAngleChange > this.nextAngleChange) {
                Random rand = new Random();
                this.angle = rand.nextInt(360);
                this.lastAngleChange = currentTick;
                this.calculateNextAngleChange();
            }
            float pixelsPerTick = (float)Game.getLoop().getDeltaTime() * 0.001f * ((DecorMob)this.getEntity()).getVelocity();
            Game.getPhysicsEngine().move((IMobileEntity)this.getEntity(), this.angle, (double)pixelsPerTick);
        }
    }

    public static enum MovementBehavior {
        IDLE,
        RANDOM,
        SHY;


        public static MovementBehavior get(String behaviour) {
            if (behaviour == null || behaviour.isEmpty()) {
                return IDLE;
            }
            try {
                return MovementBehavior.valueOf(behaviour);
            }
            catch (IllegalArgumentException iae) {
                return IDLE;
            }
        }
    }
}

