/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.annotation.AnimationInfo;
import de.gurkenlabs.litiengine.annotation.MovementInfo;
import de.gurkenlabs.litiengine.entities.CombatEntity;
import de.gurkenlabs.litiengine.entities.Direction;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.graphics.animation.CreatureAnimationController;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

@MovementInfo
public class Creature
extends CombatEntity
implements IMobileEntity {
    private static final int IDLE_DELAY = 100;
    private final List<Consumer<IMobileEntity>> entityMovedConsumer = new CopyOnWriteArrayList<Consumer<IMobileEntity>>();
    private int acceleration;
    private int deceleration;
    private long lastMoved;
    private Point2D moveDestination;
    private boolean turnOnMove;
    private short velocity;
    private String spritePrefix;

    public Creature() {
        this(null);
    }

    public Creature(String spritePrefix) {
        MovementInfo movementInfo = this.getClass().getAnnotation(MovementInfo.class);
        if (movementInfo != null) {
            this.velocity = movementInfo.velocity();
            this.acceleration = movementInfo.acceleration();
            this.deceleration = movementInfo.deceleration();
            this.setTurnOnMove(movementInfo.turnOnMove());
        }
        if (spritePrefix != null) {
            this.setSpritePrefix(spritePrefix);
        } else {
            AnimationInfo animationInfo = this.getClass().getAnnotation(AnimationInfo.class);
            if (animationInfo != null) {
                this.setSpritePrefix(animationInfo.spritePrefix());
            } else {
                this.setSpritePrefix(this.getClass().getSimpleName().toLowerCase());
            }
        }
        Game.getEntityControllerManager().addController(this, new CreatureAnimationController<Creature>(this, true));
    }

    @Override
    public int getAcceleration() {
        return this.acceleration;
    }

    @Override
    public int getDeceleration() {
        return this.deceleration;
    }

    public Direction getFacingDirection() {
        return Direction.fromAngle(this.getAngle());
    }

    @Override
    public Point2D getMoveDestination() {
        return this.moveDestination;
    }

    public String getSpritePrefix() {
        return this.spritePrefix;
    }

    @Override
    public float getVelocity() {
        return (float)this.velocity * this.getAttributes().getVelocity().getCurrentValue().floatValue();
    }

    public boolean isIdle() {
        return Game.getLoop().getDeltaTime(this.lastMoved) > 100L;
    }

    @Override
    public void onMoved(Consumer<IMobileEntity> consumer) {
        if (this.entityMovedConsumer.contains(consumer)) {
            return;
        }
        this.entityMovedConsumer.add(consumer);
    }

    @Override
    public void setAcceleration(int acceleration) {
        this.acceleration = acceleration;
    }

    @Override
    public void setDeceleration(int deceleration) {
        this.deceleration = deceleration;
    }

    public void setFacingDirection(Direction facingDirection) {
        this.setAngle(Direction.toAngle(facingDirection));
    }

    @Override
    public void setLocation(Point2D position) {
        if (this.isDead() || position == null || GeometricUtilities.equals(position, this.getLocation(), 0.001)) {
            return;
        }
        super.setLocation(position);
        if (Game.hasStarted()) {
            this.lastMoved = Game.getLoop().getTicks();
        }
        for (Consumer<IMobileEntity> consumer : this.entityMovedConsumer) {
            consumer.accept(this);
        }
    }

    @Override
    public void setMoveDestination(Point2D dest) {
        this.moveDestination = dest;
        this.setAngle(GeometricUtilities.calcRotationAngleInDegrees(this.getLocation(), this.getMoveDestination()));
    }

    @Override
    public void setTurnOnMove(boolean turn) {
        this.turnOnMove = turn;
    }

    @Override
    public void setVelocity(short velocity) {
        this.velocity = velocity;
    }

    public void setSpritePrefix(String spritePrefix) {
        this.spritePrefix = spritePrefix;
    }

    @Override
    public boolean turnOnMove() {
        return this.turnOnMove;
    }
}

