/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.abilities.Ability;
import de.gurkenlabs.litiengine.abilities.effects.IEffect;
import de.gurkenlabs.litiengine.annotation.CollisionInfo;
import de.gurkenlabs.litiengine.annotation.CombatAttributesInfo;
import de.gurkenlabs.litiengine.attributes.AttributeModifier;
import de.gurkenlabs.litiengine.attributes.Modification;
import de.gurkenlabs.litiengine.entities.CollisionEntity;
import de.gurkenlabs.litiengine.entities.CombatAttributes;
import de.gurkenlabs.litiengine.entities.CombatEntityHitArgument;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import java.awt.geom.Ellipse2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

@CombatAttributesInfo
@CollisionInfo(collision=true)
public class CombatEntity
extends CollisionEntity
implements ICombatEntity {
    private final List<IEffect> appliedEffects;
    private final List<Consumer<ICombatEntity>> entityDeathConsumer = new CopyOnWriteArrayList<Consumer<ICombatEntity>>();
    private final List<Consumer<CombatEntityHitArgument>> entityHitConsumer;
    private final List<Consumer<ICombatEntity>> entityResurrectConsumer = new CopyOnWriteArrayList<Consumer<ICombatEntity>>();
    private final CombatAttributes attributes;
    private boolean isIndestructible;
    private ICombatEntity target;
    private int team;

    public CombatEntity() {
        this.entityHitConsumer = new CopyOnWriteArrayList<Consumer<CombatEntityHitArgument>>();
        this.appliedEffects = new CopyOnWriteArrayList<IEffect>();
        CombatAttributesInfo info = this.getClass().getAnnotation(CombatAttributesInfo.class);
        this.attributes = new CombatAttributes(info);
        this.setIndestructible(false);
        this.setupAttributes(this.getAttributes());
    }

    @Override
    public void die() {
        if (this.isDead()) {
            return;
        }
        this.getAttributes().getHealth().modifyBaseValue(new AttributeModifier(Modification.SET, 0.0));
        for (Consumer<ICombatEntity> consumer : this.entityDeathConsumer) {
            consumer.accept(this);
        }
        this.setCollision(false);
    }

    @Override
    public List<IEffect> getAppliedEffects() {
        return this.appliedEffects;
    }

    @Override
    public CombatAttributes getAttributes() {
        return this.attributes;
    }

    @Override
    public Ellipse2D getHitBox() {
        return new Ellipse2D.Double(this.getLocation().getX(), this.getLocation().getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public ICombatEntity getTarget() {
        return this.target;
    }

    @Override
    public int getTeam() {
        return this.team;
    }

    @Override
    public boolean hit(int damage) {
        return this.hit(damage, null);
    }

    @Override
    public boolean hit(int damage, Ability ability) {
        if (this.isDead()) {
            return false;
        }
        int actualDamage = damage;
        if (this.getAttributes().getShield().getCurrentValue() > 0) {
            int shieldDmg = damage;
            if (shieldDmg > this.getAttributes().getShield().getCurrentValue()) {
                shieldDmg = this.getAttributes().getShield().getCurrentValue().shortValue();
            }
            this.getAttributes().getShield().modifyBaseValue(new AttributeModifier(Modification.SUBSTRACT, shieldDmg));
            actualDamage = damage - shieldDmg;
        }
        if (!this.isIndestructible()) {
            this.getAttributes().getHealth().modifyBaseValue(new AttributeModifier(Modification.SUBSTRACT, actualDamage));
        }
        if (this.isDead()) {
            this.setCollision(false);
            this.getAttributes().getHealth().modifyBaseValue(new AttributeModifier(Modification.SET, 0.0));
            for (Consumer<ICombatEntity> consumer : this.entityDeathConsumer) {
                consumer.accept(this);
            }
        }
        CombatEntityHitArgument arg = new CombatEntityHitArgument(this, actualDamage, ability);
        for (Consumer<CombatEntityHitArgument> consumer : this.entityHitConsumer) {
            consumer.accept(arg);
        }
        return this.isDead();
    }

    @Override
    public boolean isDead() {
        return this.getAttributes().getHealth().getCurrentValue() <= 0;
    }

    @Override
    public boolean isFriendly(ICombatEntity entity) {
        return this.getTeam() == entity.getTeam();
    }

    @Override
    public boolean isIndestructible() {
        return this.isIndestructible;
    }

    @Override
    public boolean isNeutral() {
        return this.getTeam() == 0;
    }

    @Override
    public void onDeath(Consumer<ICombatEntity> consumer) {
        if (this.entityDeathConsumer.contains(consumer)) {
            return;
        }
        this.entityDeathConsumer.add(consumer);
    }

    @Override
    public void onHit(Consumer<CombatEntityHitArgument> consumer) {
        if (this.entityHitConsumer.contains(consumer)) {
            return;
        }
        this.entityHitConsumer.add(consumer);
    }

    @Override
    public void onResurrect(Consumer<ICombatEntity> consumer) {
        if (this.entityResurrectConsumer.contains(consumer)) {
            return;
        }
        this.entityResurrectConsumer.add(consumer);
    }

    @Override
    public void resurrect() {
        if (!this.isDead()) {
            return;
        }
        this.getAttributes().getHealth().modifyBaseValue(new AttributeModifier(Modification.SET, this.getAttributes().getHealth().getMaxValue().shortValue()));
        for (Consumer<ICombatEntity> consumer : this.entityResurrectConsumer) {
            consumer.accept(this);
        }
        this.setCollision(true);
    }

    @Override
    public void setIndestructible(boolean indestructible) {
        this.isIndestructible = indestructible;
    }

    @Override
    public void setTarget(ICombatEntity target) {
        this.target = target;
    }

    @Override
    public void setTeam(int team) {
        this.team = team;
    }

    protected void setupAttributes(CombatAttributes attributes) {
    }
}

