/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.configuration;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroup;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroupInfo;

@ConfigurationGroupInfo(prefix="dbg_", debug=true)
public class DebugConfiguration
extends ConfigurationGroup {
    private boolean debugEnabled = false;
    private boolean renderAStarInfo = false;
    private boolean renderBoundingBoxes = false;
    private boolean renderCollisionBoxes = false;
    private boolean renderDebugMouse = false;
    private boolean renderEntityNames = false;
    private boolean renderGuiComponentBoundingBoxes = false;
    private boolean renderHitBoxes = false;
    private boolean renderPaths = false;
    private boolean showMouseTargetMetric = true;
    private boolean showTilesMetric = false;

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isRenderAStarInfo() {
        return this.renderAStarInfo;
    }

    public boolean isRenderDebugMouse() {
        return this.isDebugEnabled() && this.renderDebugMouse;
    }

    public boolean renderBoundingBoxes() {
        return this.isDebugEnabled() && this.renderBoundingBoxes;
    }

    public boolean renderCollisionBoxes() {
        return this.isDebugEnabled() && this.renderCollisionBoxes;
    }

    public boolean renderEntityNames() {
        return this.isDebugEnabled() && this.renderEntityNames;
    }

    public boolean renderHitBoxes() {
        return this.isDebugEnabled() && this.renderHitBoxes;
    }

    public boolean renderPaths() {
        return this.isDebugEnabled() && this.renderPaths;
    }

    public boolean renderGuiComponentBoundingBoxes() {
        return this.renderGuiComponentBoundingBoxes;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = Game.isDebug() && debugEnabled;
    }

    public void setRenderAStarInfo(boolean renderAStarInfo) {
        this.renderAStarInfo = renderAStarInfo;
    }

    public void setRenderBoundingBoxes(boolean renderBoundingBoxes) {
        this.renderBoundingBoxes = renderBoundingBoxes;
    }

    public void setRenderCollisionBoxes(boolean renderCollisionBoxes) {
        this.renderCollisionBoxes = renderCollisionBoxes;
    }

    public void setRenderDebugMouse(boolean renderDebugMouse) {
        this.renderDebugMouse = renderDebugMouse;
    }

    public void setRenderEntityNames(boolean renderEntityNames) {
        this.renderEntityNames = renderEntityNames;
    }

    public void setRenderHitBoxes(boolean renderHitBoxes) {
        this.renderHitBoxes = renderHitBoxes;
    }

    public void setRenderPaths(boolean renderPaths) {
        this.renderPaths = renderPaths;
    }

    public void setShowMouseTargetMetric(boolean showMouseTargetMetric) {
        this.showMouseTargetMetric = showMouseTargetMetric;
    }

    public void setShowTilesMetric(boolean showTilesMetric) {
        this.showTilesMetric = showTilesMetric;
    }

    public void setRenderGuiComponentBoundingBoxes(boolean renderGuiComponentBoundingBoxes) {
        this.renderGuiComponentBoundingBoxes = renderGuiComponentBoundingBoxes;
    }

    public boolean showMouseTargetMetric() {
        return this.isDebugEnabled() && this.showMouseTargetMetric;
    }

    public boolean showTilesMetric() {
        return this.isDebugEnabled() && this.showTilesMetric;
    }
}

