/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.configuration;

import de.gurkenlabs.litiengine.configuration.ConfigurationGroupInfo;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@ConfigurationGroupInfo
public abstract class ConfigurationGroup {
    private static final Logger log = Logger.getLogger(ConfigurationGroup.class.getName());
    private final String prefix;
    private boolean debug;

    public ConfigurationGroup() {
        ConfigurationGroupInfo info = this.getClass().getAnnotation(ConfigurationGroupInfo.class);
        this.prefix = info.prefix();
        this.debug = info.debug();
    }

    public String getPrefix() {
        return this.prefix != null ? this.prefix : "";
    }

    protected void initializeByProperty(String key, String value) {
        String propertyName = key.substring(this.getPrefix().length());
        this.initializeProperty(propertyName, value);
    }

    protected void initializeProperty(String propertyName, String value) {
        Field field = this.getField(propertyName);
        if (field == null) {
            return;
        }
        try {
            if (field.getType().equals(Boolean.TYPE)) {
                this.setPropertyValue(propertyName, Boolean.parseBoolean(value));
            } else if (field.getType().equals(Integer.TYPE)) {
                this.setPropertyValue(propertyName, Integer.parseInt(value));
            } else if (field.getType().equals(Float.TYPE)) {
                this.setPropertyValue(propertyName, Float.valueOf(Float.parseFloat(value)));
            } else if (field.getType().equals(Double.TYPE)) {
                this.setPropertyValue(propertyName, Double.parseDouble(value));
            } else if (field.getType().equals(Short.TYPE)) {
                this.setPropertyValue(propertyName, Short.parseShort(value));
            } else if (field.getType().equals(Byte.TYPE)) {
                this.setPropertyValue(propertyName, Byte.parseByte(value));
            } else if (field.getType().equals(Long.TYPE)) {
                this.setPropertyValue(propertyName, Long.parseLong(value));
            } else if (field.getType().equals(String.class)) {
                this.setPropertyValue(propertyName, value);
            } else if (field.getType().equals(String[].class)) {
                this.setPropertyValue(propertyName, value.split(","));
            } else if (field.getType() instanceof Class && field.getType().isEnum()) {
                this.setEnumPropertyValue(field, propertyName, value);
            }
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected void storeProperties(Properties properties) {
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if (field.getType().equals(Boolean.TYPE)) {
                    properties.setProperty(this.getPrefix() + field.getName(), Boolean.toString(field.getBoolean(this)));
                    continue;
                }
                if (field.getType().equals(Integer.TYPE)) {
                    properties.setProperty(this.getPrefix() + field.getName(), Integer.toString(field.getInt(this)));
                    continue;
                }
                if (field.getType().equals(Float.TYPE)) {
                    properties.setProperty(this.getPrefix() + field.getName(), Float.toString(field.getFloat(this)));
                    continue;
                }
                if (field.getType().equals(Double.TYPE)) {
                    properties.setProperty(this.getPrefix() + field.getName(), Double.toString(field.getDouble(this)));
                    continue;
                }
                if (field.getType().equals(Byte.TYPE)) {
                    properties.setProperty(this.getPrefix() + field.getName(), Byte.toString(field.getByte(this)));
                    continue;
                }
                if (field.getType().equals(Short.TYPE)) {
                    properties.setProperty(this.getPrefix() + field.getName(), Short.toString(field.getShort(this)));
                    continue;
                }
                if (field.getType().equals(Long.TYPE)) {
                    properties.setProperty(this.getPrefix() + field.getName(), Long.toString(field.getLong(this)));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    properties.setProperty(this.getPrefix() + field.getName(), field.get(this) != null ? (String)field.get(this) : "");
                    continue;
                }
                if (field.getType().equals(String[].class)) {
                    properties.setProperty(this.getPrefix() + field.getName(), field.get(this) != null ? String.join((CharSequence)",", (String[])field.get(this)) : "");
                    continue;
                }
                if (!(field.getType() instanceof Class) || !field.getType().isEnum()) continue;
                Object val = field.get(this);
                String value = val == null && field.getType().getEnumConstants().length > 0 ? field.getType().getEnumConstants()[0].toString() : "";
                properties.setProperty(this.getPrefix() + field.getName(), val != null ? val.toString() : value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private Field getField(String fieldName) {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.getName().equalsIgnoreCase(fieldName)) continue;
            return field;
        }
        return null;
    }

    private Method getSetter(String fieldName) {
        for (Method method : this.getClass().getMethods()) {
            if (!method.getName().equalsIgnoreCase("set" + fieldName) || method.getParameters().length != 1) continue;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method;
        }
        return null;
    }

    private <T> void setPropertyValue(String propertyName, T value) {
        try {
            Method method = this.getSetter(propertyName);
            if (method != null) {
                method.invoke((Object)this, value);
            } else {
                for (Field field : this.getClass().getDeclaredFields()) {
                    if (!field.getName().equals(propertyName) || !field.getType().equals(value.getClass())) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    field.set(this, value);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void setEnumPropertyValue(Field field, String propertyName, String value) {
        ?[] enumArray;
        for (Object enumConst : enumArray = field.getType().getEnumConstants()) {
            if (enumConst == null || !enumConst.toString().equalsIgnoreCase(value)) continue;
            this.setPropertyValue(propertyName, field.getType().cast(enumConst));
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

