/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.configuration;

import de.gurkenlabs.litiengine.configuration.ConfigurationGroup;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroupInfo;
import java.util.Locale;

@ConfigurationGroupInfo(prefix="cl_")
public class ClientConfiguration
extends ConfigurationGroup {
    private String country;
    private String language;
    private int maxFps;
    private boolean showGameMetrics;
    private int updaterate;

    public ClientConfiguration() {
        this.setUpdaterate(60);
        this.setMaxFps(60);
        this.setShowGameMetrics(false);
        this.setLanguage(Locale.getDefault().getLanguage());
        this.setCountry(Locale.getDefault().getCountry());
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguage() {
        return this.language;
    }

    public Locale getLocale() {
        if (this.getCountry() == null || this.getCountry().isEmpty()) {
            return new Locale(this.getLanguage());
        }
        return new Locale(this.getLanguage(), this.getCountry());
    }

    public int getMaxFps() {
        return this.maxFps;
    }

    public int getUpdaterate() {
        return this.updaterate;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setMaxFps(int maxFps) {
        if (maxFps < 1) {
            return;
        }
        this.maxFps = maxFps;
    }

    public void setShowGameMetrics(boolean showGameMetrics) {
        this.showGameMetrics = showGameMetrics;
    }

    public void setUpdaterate(int updaterate) {
        if (updaterate < 1 || updaterate > 500) {
            return;
        }
        this.updaterate = updaterate;
    }

    public boolean showGameMetrics() {
        return this.showGameMetrics;
    }
}

