/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.abilities.Ability;
import de.gurkenlabs.litiengine.abilities.effects.IEffect;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AbilityExecution
implements IUpdateable {
    private final Ability ability;
    private final List<IEffect> appliedEffects = new CopyOnWriteArrayList<IEffect>();
    private final Point2D castLocation;
    private final long executionTicks;
    private final Shape impactArea;

    public AbilityExecution(Ability ability) {
        this.ability = ability;
        this.executionTicks = Game.getLoop().getTicks();
        this.impactArea = ability.calculateImpactArea();
        this.castLocation = ability.getExecutor().getDimensionCenter();
        Game.getLoop().attach(this);
    }

    public Ability getAbility() {
        return this.ability;
    }

    public List<IEffect> getAppliedEffects() {
        return this.appliedEffects;
    }

    public Point2D getCastLocation() {
        return this.castLocation;
    }

    public Shape getExecutionImpactArea() {
        return this.impactArea;
    }

    public long getExecutionTicks() {
        return this.executionTicks;
    }

    @Override
    public void update() {
        if (this.getAbility().getEffects().isEmpty() || this.getAbility().getEffects().size() == this.getAppliedEffects().size()) {
            Game.getLoop().detach(this);
            return;
        }
        for (IEffect effect : this.getAbility().getEffects()) {
            if (this.getAppliedEffects().contains(effect) || Game.getLoop().getDeltaTime(this.getExecutionTicks()) < (long)effect.getDelay()) continue;
            effect.apply(this.getExecutionImpactArea());
            this.getAppliedEffects().add(effect);
        }
    }
}

