/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IGameLoop;
import de.gurkenlabs.litiengine.abilities.AbilityAttributes;
import de.gurkenlabs.litiengine.abilities.AbilityExecution;
import de.gurkenlabs.litiengine.abilities.AbilityOrigin;
import de.gurkenlabs.litiengine.abilities.CastType;
import de.gurkenlabs.litiengine.abilities.effects.EffectArgument;
import de.gurkenlabs.litiengine.abilities.effects.IEffect;
import de.gurkenlabs.litiengine.annotation.AbilityInfo;
import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

@AbilityInfo
public abstract class Ability
implements IRenderable {
    private final List<Consumer<AbilityExecution>> abilityCastConsumer = new CopyOnWriteArrayList<Consumer<AbilityExecution>>();
    private final AbilityAttributes attributes;
    private final CastType castType;
    private final String description;
    private final List<IEffect> effects = new CopyOnWriteArrayList<IEffect>();
    private final Creature executor;
    private final boolean multiTarget;
    private final String name;
    private final AbilityOrigin originType;
    private AbilityExecution currentExecution;
    private Point2D origin;

    protected Ability(Creature executor) {
        AbilityInfo info = this.getClass().getAnnotation(AbilityInfo.class);
        this.attributes = new AbilityAttributes(info);
        this.executor = executor;
        this.name = info.name();
        this.multiTarget = info.multiTarget();
        this.description = info.description();
        this.castType = info.castType();
        this.originType = info.origin();
    }

    public void addEffect(IEffect effect) {
        this.getEffects().add(effect);
    }

    public Shape calculateImpactArea() {
        return this.internalCalculateImpactArea(this.getExecutor().getAngle());
    }

    public Ellipse2D calculatePotentialImpactArea() {
        int range = this.getAttributes().getImpact().getCurrentValue();
        double arcX = this.getExecutor().getCollisionBox().getCenterX() - (double)range * 0.5;
        double arcY = this.getExecutor().getCollisionBox().getCenterY() - (double)range * 0.5;
        return new Ellipse2D.Double(arcX, arcY, range, range);
    }

    public boolean canCast() {
        return !this.getExecutor().isDead() && (this.getCurrentExecution() == null || this.getCurrentExecution().getExecutionTicks() == 0L || Game.getLoop().getDeltaTime(this.getCurrentExecution().getExecutionTicks()) >= (long)this.getAttributes().getCooldown().getCurrentValue().intValue());
    }

    public AbilityExecution cast() {
        if (!this.canCast()) {
            return null;
        }
        this.currentExecution = new AbilityExecution(this);
        for (Consumer<AbilityExecution> castConsumer : this.abilityCastConsumer) {
            castConsumer.accept(this.currentExecution);
        }
        return this.getCurrentExecution();
    }

    public AbilityAttributes getAttributes() {
        return this.attributes;
    }

    public CastType getCastType() {
        return this.castType;
    }

    public float getCooldownInSeconds() {
        return (float)((double)this.getAttributes().getCooldown().getCurrentValue().intValue() * 0.001);
    }

    public AbilityExecution getCurrentExecution() {
        return this.currentExecution;
    }

    public String getDescription() {
        return this.description;
    }

    public Creature getExecutor() {
        return this.executor;
    }

    public String getName() {
        return this.name;
    }

    public Point2D getOrigin() {
        switch (this.originType) {
            case COLLISIONBOX_CENTER: {
                return new Point2D.Double(this.executor.getCollisionBox().getCenterX(), this.executor.getCollisionBox().getCenterY());
            }
            case DIMENSION_CENTER: {
                return this.executor.getDimensionCenter();
            }
            case CUSTOM: {
                if (this.origin == null) break;
                return new Point2D.Double(this.executor.getLocation().getX() + this.origin.getX(), this.executor.getLocation().getY() + this.origin.getY());
            }
        }
        return this.executor.getLocation();
    }

    public float getRemainingCooldownInSeconds(IGameLoop loop) {
        if (this.getCurrentExecution() == null || this.getExecutor() == null || this.getExecutor().isDead()) {
            return 0.0f;
        }
        return (float)(!this.canCast() ? (double)((long)this.getAttributes().getCooldown().getCurrentValue().intValue() - loop.getDeltaTime(this.getCurrentExecution().getExecutionTicks())) * 0.001 : 0.0);
    }

    public boolean isCasting(IGameLoop gameLoop) {
        return this.getCurrentExecution() != null && gameLoop.getDeltaTime(this.getCurrentExecution().getExecutionTicks()) < (long)this.getAttributes().getDuration().getCurrentValue().intValue();
    }

    public boolean isMultiTarget() {
        return this.multiTarget;
    }

    public void onCast(Consumer<AbilityExecution> castConsumer) {
        if (!this.abilityCastConsumer.contains(castConsumer)) {
            this.abilityCastConsumer.add(castConsumer);
        }
    }

    public void onEffectApplied(Consumer<EffectArgument> consumer) {
        for (IEffect effect : this.getEffects()) {
            this.onEffectApplied(effect, consumer);
        }
    }

    public void onEffectCeased(Consumer<EffectArgument> consumer) {
        for (IEffect effect : this.getEffects()) {
            this.onEffectCeased(effect, consumer);
        }
    }

    @Override
    public void render(Graphics2D g) {
        g.setColor(new Color(255, 255, 0, 100));
        Game.getRenderEngine().renderShape(g, this.calculateImpactArea());
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(new Color(255, 255, 0, 200));
        Game.getRenderEngine().renderOutline(g, this.calculateImpactArea());
        g.setStroke(oldStroke);
    }

    public void setOrigin(Point2D origin) {
        this.origin = origin;
    }

    protected List<IEffect> getEffects() {
        return this.effects;
    }

    protected Shape internalCalculateImpactArea(float angle) {
        int impact = this.getAttributes().getImpact().getCurrentValue();
        int impactAngle = this.getAttributes().getImpactAngle().getCurrentValue();
        double arcX = this.getOrigin().getX() - (double)impact * 0.5;
        double arcY = this.getOrigin().getY() - (double)impact * 0.5;
        Point2D appliedRange = GeometricUtilities.project((Point2D)new Point2D.Double(arcX, arcY), angle, (double)this.getAttributes().getRange().getCurrentValue().intValue() * 0.5);
        double start = angle - 90.0f;
        if (impactAngle % 360 == 0) {
            return new Ellipse2D.Double(appliedRange.getX(), appliedRange.getY(), impact, impact);
        }
        return new Arc2D.Double(appliedRange.getX(), appliedRange.getY(), impact, impact, start, impactAngle, 2);
    }

    private void onEffectApplied(IEffect effect, Consumer<EffectArgument> consumer) {
        effect.onEffectApplied(consumer);
        for (IEffect followUp : effect.getFollowUpEffects()) {
            this.onEffectApplied(followUp, consumer);
        }
    }

    private void onEffectCeased(IEffect effect, Consumer<EffectArgument> consumer) {
        effect.onEffectCeased(consumer);
        for (IEffect followUp : effect.getFollowUpEffects()) {
            this.onEffectCeased(followUp, consumer);
        }
    }
}

