/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.ILoop;
import de.gurkenlabs.litiengine.IUpdateable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class UpdateLoop
extends Thread
implements ILoop {
    private static final Logger log = Logger.getLogger(UpdateLoop.class.getName());
    private final Set<IUpdateable> updatables = Collections.newSetFromMap(new ConcurrentHashMap());

    protected UpdateLoop() {
    }

    @Override
    public void run() {
    }

    @Override
    public void attach(IUpdateable updatable) {
        if (updatable == null) {
            return;
        }
        if (this.updatables.contains(updatable)) {
            log.log(Level.FINE, "Updatable {0} already registered for update!", new Object[]{updatable});
            return;
        }
        this.updatables.add(updatable);
    }

    @Override
    public void detach(IUpdateable updatable) {
        this.updatables.remove(updatable);
    }

    protected Set<IUpdateable> getUpdatables() {
        return this.updatables;
    }

    protected void update() {
        this.getUpdatables().forEach(updatable -> {
            try {
                if (updatable != null) {
                    updatable.update();
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        });
    }
}

