/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.graphics.ImageCache;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public final class Resources {
    public static final String LOCALIZATION_RESOURCE_FOLDER = "localization/";
    public static final String DEFAULT_BUNDLE = "strings";
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final String ENCODING_UTF_8 = "UTF-8";
    private static String encoding = "ISO-8859-1";
    private static final Logger log = Logger.getLogger(Resources.class.getName());

    private Resources() {
    }

    public static void setEncoding(String newEncoding) {
        if (newEncoding == null || newEncoding.isEmpty()) {
            throw new IllegalArgumentException("The encoding must not be null or empty.");
        }
        encoding = newEncoding;
    }

    public static String get(String key) {
        if (key == null) {
            return null;
        }
        return Resources.getFrom(DEFAULT_BUNDLE, key, new Object[0]);
    }

    public static String get(String key, Object ... args) {
        if (key == null) {
            return null;
        }
        return Resources.getFrom(DEFAULT_BUNDLE, key, args);
    }

    public static String getFrom(String bundleName, String key, Object ... args) {
        if (key == bundleName) {
            return null;
        }
        try {
            String decodedValue;
            ResourceBundle defaultBundle = ResourceBundle.getBundle(LOCALIZATION_RESOURCE_FOLDER + bundleName, Game.getConfiguration().client().getLocale());
            String value = defaultBundle.getString(key);
            String string = decodedValue = encoding.equals(ENCODING_ISO_8859_1) ? value : new String(value.getBytes(ENCODING_ISO_8859_1), encoding);
            if (args.length > 0) {
                return MessageFormat.format(decodedValue, args);
            }
            return decodedValue;
        }
        catch (UnsupportedEncodingException | MissingResourceException me) {
            StringWriter sw = new StringWriter();
            me.printStackTrace(new PrintWriter(sw));
            String stacktrace = sw.toString();
            log.severe(stacktrace);
            return key;
        }
    }

    public static BufferedImage getImage(String absolutPath) {
        return Resources.getImage(absolutPath, false);
    }

    public static BufferedImage getImage(String absolutPath, boolean forceLoad) {
        if (absolutPath == null || absolutPath.isEmpty()) {
            return null;
        }
        String cacheKey = Integer.toString(absolutPath.hashCode());
        if (!forceLoad && ImageCache.IMAGES.containsKey(cacheKey)) {
            return ImageCache.IMAGES.get(cacheKey);
        }
        BufferedImage img = null;
        InputStream imageFile = FileUtilities.getGameResource(absolutPath);
        if (imageFile != null) {
            try {
                img = ImageIO.read(imageFile);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
        if (img == null) {
            return null;
        }
        BufferedImage compatibleImg = ImageProcessing.getCompatibleImage(img.getWidth(), img.getHeight());
        compatibleImg.createGraphics().drawImage((Image)img, 0, 0, null);
        ImageCache.IMAGES.put(cacheKey, compatibleImg);
        return compatibleImg;
    }

    static {
        Locale.setDefault(new Locale("en", "US"));
    }
}

