/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.UpdateLoop;
import de.gurkenlabs.litiengine.graphics.IRenderComponent;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RenderLoop
extends UpdateLoop {
    private static final Logger log = Logger.getLogger(RenderLoop.class.getName());
    private final IRenderComponent component;
    private final List<IRenderable> renderables = new CopyOnWriteArrayList<IRenderable>();
    private boolean gameIsRunning = true;
    private int maxFps;

    public RenderLoop(IRenderComponent component) {
        this.component = component;
        this.maxFps = Game.getConfiguration().client().getMaxFps();
    }

    public void register(IRenderable render) {
        this.renderables.add(render);
    }

    @Override
    public void run() {
        while (this.gameIsRunning) {
            long fpsWait = (long)(1.0 / (double)this.maxFps * 1000.0);
            long renderStart = System.nanoTime();
            try {
                Game.getCamera().updateFocus();
                this.update();
                for (IRenderable render : this.renderables) {
                    this.component.render(render);
                }
                long renderTime = (System.nanoTime() - renderStart) / 1000000L;
                Thread.sleep(Math.max(0L, fpsWait - renderTime));
            }
            catch (InterruptedException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    public void terminate() {
        this.gameIsRunning = false;
    }

    public void unregister(IRenderable render) {
        this.renderables.remove(render);
    }

    public int getMaxFps() {
        return this.maxFps;
    }

    public void setMaxFps(int maxFps) {
        this.maxFps = maxFps;
    }
}

