/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.DefaultUncaughtExceptionHandler;
import de.gurkenlabs.litiengine.GameFile;
import de.gurkenlabs.litiengine.GameInfo;
import de.gurkenlabs.litiengine.GameLoop;
import de.gurkenlabs.litiengine.GameMetrics;
import de.gurkenlabs.litiengine.GameTime;
import de.gurkenlabs.litiengine.IGameLoop;
import de.gurkenlabs.litiengine.RenderLoop;
import de.gurkenlabs.litiengine.Resources;
import de.gurkenlabs.litiengine.SpriteSheetInfo;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroup;
import de.gurkenlabs.litiengine.configuration.GameConfiguration;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.ai.EntityControllerManager;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.graphics.Camera;
import de.gurkenlabs.litiengine.graphics.DebugRenderer;
import de.gurkenlabs.litiengine.graphics.ICamera;
import de.gurkenlabs.litiengine.graphics.IRenderEngine;
import de.gurkenlabs.litiengine.graphics.RenderEngine;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.screens.IScreenManager;
import de.gurkenlabs.litiengine.gui.screens.ScreenManager;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.physics.IPhysicsEngine;
import de.gurkenlabs.litiengine.physics.PhysicsEngine;
import de.gurkenlabs.litiengine.sound.ISoundEngine;
import de.gurkenlabs.litiengine.sound.SoundEngine;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class Game {
    protected static long environmentLoadTick;
    private static final Logger log;
    private static final String LOGGING_CONFIG_FILE = "logging.properties";
    private static boolean debug;
    private static final List<Consumer<String>> startedConsumer;
    private static final List<Predicate<String>> terminatingConsumer;
    private static final List<Consumer<GameConfiguration>> configLoadedConsumer;
    private static final List<Consumer<IEnvironment>> environmentLoadedConsumer;
    private static final GameConfiguration configuration;
    private static final EntityControllerManager entityControllerManager;
    private static final IRenderEngine graphicsEngine;
    private static final GameInfo info;
    private static final List<IMap> maps;
    private static final List<ITileset> tilesets;
    private static final GameMetrics metrics;
    private static final IPhysicsEngine physicsEngine;
    private static final ISoundEngine soundEngine;
    private static final GameTime gameTime;
    private static IEnvironment environment;
    private static ICamera camera;
    private static IGameLoop gameLoop;
    private static RenderLoop renderLoop;
    private static IScreenManager screenManager;
    private static boolean hasStarted;

    private Game() {
    }

    public static void allowDebug(boolean allow) {
        debug = allow;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static GameConfiguration getConfiguration() {
        return configuration;
    }

    public static EntityControllerManager getEntityControllerManager() {
        return entityControllerManager;
    }

    public static IEnvironment getEnvironment() {
        return environment;
    }

    public static GameInfo getInfo() {
        return info;
    }

    public static IGameLoop getLoop() {
        return gameLoop;
    }

    public static IMap getMap(String mapName) {
        if (mapName == null || mapName.isEmpty() || maps.isEmpty()) {
            return null;
        }
        for (IMap map : maps) {
            if (!map.getFileName().equals(mapName)) continue;
            return map;
        }
        return null;
    }

    public static List<IMap> getMaps() {
        return maps;
    }

    public static List<ITileset> getTilesets() {
        return tilesets;
    }

    public static GameMetrics getMetrics() {
        return metrics;
    }

    public static IPhysicsEngine getPhysicsEngine() {
        return physicsEngine;
    }

    public static IRenderEngine getRenderEngine() {
        return graphicsEngine;
    }

    public static RenderLoop getRenderLoop() {
        return renderLoop;
    }

    public static IScreenManager getScreenManager() {
        return screenManager;
    }

    public static ISoundEngine getSoundEngine() {
        return soundEngine;
    }

    public static ICamera getCamera() {
        return camera;
    }

    public static GameTime getTime() {
        return gameTime;
    }

    public static void init() {
        Game.getConfiguration().load();
        Locale.setDefault(new Locale(Game.getConfiguration().client().getCountry(), Game.getConfiguration().client().getLanguage()));
        for (Consumer<GameConfiguration> cons : configLoadedConsumer) {
            cons.accept(Game.getConfiguration());
        }
        GameLoop updateLoop = new GameLoop(Game.getConfiguration().client().getUpdaterate());
        updateLoop.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
        gameLoop = updateLoop;
        Game.getLoop().attach(Game.getPhysicsEngine());
        ScreenManager scrMgr = new ScreenManager(Game.getInfo().toString());
        renderLoop = new RenderLoop(scrMgr.getRenderComponent());
        renderLoop.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
        Game.getLoop().onUpsTracked(updateCount -> Game.getMetrics().setUpdatesPerSecond(updateCount.intValue()));
        Thread.setDefaultUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
        screenManager = scrMgr;
        Game.getScreenManager().init(Game.getConfiguration().graphics().getResolutionWidth(), Game.getConfiguration().graphics().getResolutionHeight(), Game.getConfiguration().graphics().isFullscreen());
        Game.setCamera(new Camera());
        if (new File(LOGGING_CONFIG_FILE).exists()) {
            System.setProperty("java.util.logging.config.file", LOGGING_CONFIG_FILE);
            try {
                LogManager.getLogManager().readConfiguration();
            }
            catch (Exception e2) {
                log.log(Level.SEVERE, e2.getMessage(), e2);
            }
        }
        if (Game.getConfiguration().client().showGameMetrics()) {
            Game.getScreenManager().getRenderComponent().onRendered(g -> Game.getMetrics().render((Graphics2D)g));
        }
        if (Game.getConfiguration().debug().isDebugEnabled()) {
            Game.getRenderEngine().onEntityRendered(e -> DebugRenderer.renderEntityDebugInfo(e.getGraphics(), (IEntity)e.getRenderedObject()));
        }
        Game.getRenderEngine().onMapRendered(e -> DebugRenderer.renderMapDebugInfo(e.getGraphics(), (IMap)e.getRenderedObject()));
        Game.getScreenManager().getRenderComponent().onFpsChanged(fps -> Game.getMetrics().setFramesPerSecond(fps.intValue()));
        Game.getScreenManager().setIconImage(Resources.getImage("litiengine-icon.png"));
        Input.init();
        Game.getScreenManager().getRenderComponent().addMouseListener(Input.mouse());
        Game.getScreenManager().getRenderComponent().addMouseMotionListener(Input.mouse());
        Game.getScreenManager().getRenderComponent().addMouseWheelListener(Input.mouse());
        Input.keyboard().onKeyTyped(154, key -> Game.getScreenManager().getRenderComponent().takeScreenshot());
    }

    /*
     * WARNING - void declaration
     */
    public static void load(String gameResourceFile) {
        void var5_11;
        GameFile file = GameFile.load(gameResourceFile);
        if (file == null) {
            return;
        }
        int mapCnt = 0;
        for (IMap iMap : file.getMaps()) {
            if (Game.getMaps().stream().anyMatch(x -> x.getFileName().equals(iMap.getFileName()))) continue;
            Game.getMaps().add(iMap);
            ++mapCnt;
        }
        log.log(Level.INFO, "{0} maps loaded from {1}", new Object[]{mapCnt, gameResourceFile});
        int tileCnt = 0;
        for (ITileset iTileset : file.getTilesets()) {
            if (Game.getTilesets().stream().anyMatch(x -> x.getName().equals(iTileset.getName()))) continue;
            Game.getTilesets().add(iTileset);
            ++tileCnt;
        }
        log.log(Level.INFO, "{0} tilesets loaded from {1}", new Object[]{tileCnt, gameResourceFile});
        ArrayList<Spritesheet> arrayList = new ArrayList<Spritesheet>();
        for (SpriteSheetInfo tileset : file.getSpriteSheets()) {
            Spritesheet sprite = Spritesheet.load(tileset);
            arrayList.add(sprite);
        }
        log.log(Level.INFO, "{0} spritesheets loaded from {1}", new Object[]{arrayList.size(), gameResourceFile});
        boolean bl = false;
        for (Spritesheet s : arrayList) {
            for (int i = 0; i < s.getRows() * s.getColumns(); ++i) {
                BufferedImage sprite = s.getSprite(i);
                if (sprite == null) continue;
                ++var5_11;
            }
        }
        log.log(Level.INFO, "{0} sprites loaded to memory", new Object[]{(int)var5_11});
    }

    public static void loadEnvironment(IEnvironment env) {
        if (Game.getEnvironment() != null) {
            Game.getEnvironment().unload();
        }
        environment = env;
        if (Game.getEnvironment() != null) {
            Game.getEnvironment().load();
        }
        for (Consumer<IEnvironment> cons : environmentLoadedConsumer) {
            cons.accept(Game.getEnvironment());
        }
        if (Game.getLoop() != null) {
            environmentLoadTick = Game.getLoop().getTicks();
        }
    }

    public static void onEnvironmentLoaded(Consumer<IEnvironment> cons) {
        environmentLoadedConsumer.add(cons);
    }

    public static void onStarted(Consumer<String> cons) {
        startedConsumer.add(cons);
    }

    public static void onTerminating(Predicate<String> terminationPredicate) {
        terminatingConsumer.add(terminationPredicate);
    }

    public static void onConfigurationLoaded(Consumer<GameConfiguration> cons) {
        configLoadedConsumer.add(cons);
    }

    public static void start() {
        gameLoop.start();
        Input.start();
        soundEngine.start();
        renderLoop.start();
        for (Consumer<String> cons : startedConsumer) {
            cons.accept(Game.getInfo().getName());
        }
        hasStarted = true;
    }

    public static void terminate() {
        for (Predicate<String> cons : terminatingConsumer) {
            if (cons.test(Game.getInfo().getName())) continue;
            return;
        }
        Game.getConfiguration().save();
        Input.terminate();
        gameLoop.terminate();
        soundEngine.terminate();
        renderLoop.terminate();
        System.exit(0);
    }

    public static boolean hasStarted() {
        return hasStarted;
    }

    public static void setCamera(ICamera cam) {
        if (Game.getCamera() != null) {
            Game.getLoop().detach(camera);
        }
        Game.getLoop().attach(cam);
        camera = cam;
        Game.getCamera().updateFocus();
    }

    static {
        log = Logger.getLogger(Game.class.getName());
        debug = true;
        startedConsumer = new CopyOnWriteArrayList<Consumer<String>>();
        terminatingConsumer = new CopyOnWriteArrayList<Predicate<String>>();
        environmentLoadedConsumer = new CopyOnWriteArrayList<Consumer<IEnvironment>>();
        configLoadedConsumer = new CopyOnWriteArrayList<Consumer<GameConfiguration>>();
        graphicsEngine = new RenderEngine();
        physicsEngine = new PhysicsEngine();
        soundEngine = new SoundEngine();
        metrics = new GameMetrics();
        entityControllerManager = new EntityControllerManager();
        info = new GameInfo();
        maps = new CopyOnWriteArrayList<IMap>();
        tilesets = new CopyOnWriteArrayList<ITileset>();
        gameTime = new GameTime();
        configuration = new GameConfiguration(new ConfigurationGroup[0]);
    }
}

