/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.sound.SoundPlayback;
import de.gurkenlabs.litiengine.sound.Track;
import javax.sound.sampled.LineUnavailableException;

public class MusicPlayback
extends SoundPlayback {
    private final Track track;
    private final SoundPlayback.VolumeControl musicVolume;

    MusicPlayback(Track track) throws LineUnavailableException {
        super(track.getFormat());
        this.track = track;
        this.musicVolume = this.createVolumeControl();
        this.musicVolume.set(Game.config().sound().getMusicVolume());
    }

    @Override
    public void run() {
        try {
            for (Sound sound : this.track) {
                if (!this.play(sound)) continue;
                return;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.finish();
        }
    }

    public Track getTrack() {
        return this.track;
    }

    void setMusicVolume(float volume) {
        this.musicVolume.set(volume);
    }
}

