/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.input.IKeyboard;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Keyboard
implements KeyEventDispatcher,
IKeyboard,
IUpdateable {
    private final Collection<KeyListener> keyListeners = ConcurrentHashMap.newKeySet();
    private final Map<Integer, Collection<IKeyboard.KeyPressedListener>> keySpecificPressedListener = new ConcurrentHashMap<Integer, Collection<IKeyboard.KeyPressedListener>>();
    private final Map<Integer, Collection<IKeyboard.KeyReleasedListener>> keySpecificReleasedListener = new ConcurrentHashMap<Integer, Collection<IKeyboard.KeyReleasedListener>>();
    private final Map<Integer, Collection<IKeyboard.KeyTypedListener>> keySpecificTypedListener = new ConcurrentHashMap<Integer, Collection<IKeyboard.KeyTypedListener>>();
    private final Collection<IKeyboard.KeyPressedListener> keyPressedListener = ConcurrentHashMap.newKeySet();
    private final Collection<IKeyboard.KeyReleasedListener> keyReleasedListener = ConcurrentHashMap.newKeySet();
    private final Collection<IKeyboard.KeyTypedListener> keyTypedListener = ConcurrentHashMap.newKeySet();
    private final Collection<KeyEvent> pressedKeys = ConcurrentHashMap.newKeySet();
    private final Collection<KeyEvent> releasedKeys = ConcurrentHashMap.newKeySet();
    private final Collection<KeyEvent> typedKeys = ConcurrentHashMap.newKeySet();
    private boolean consumeAlt;

    Keyboard() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.consumeAlt = true;
    }

    @Override
    public void consumeAlt(boolean consume) {
        this.consumeAlt = consume;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.consumeAlt && e.getKeyCode() == 18) {
            e.consume();
        }
        int eventId = e.getID();
        switch (eventId) {
            case 401: {
                this.addPressedKey(e);
                break;
            }
            case 402: {
                this.removePressedKey(e);
                this.addTypedKey(e);
                this.addReleasedKey(e);
                break;
            }
        }
        return false;
    }

    @Override
    public boolean isPressed(int keyCode) {
        for (KeyEvent key : this.pressedKeys) {
            if (key.getKeyCode() != keyCode) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean wasReleased(int keyCode) {
        for (KeyEvent key : this.releasedKeys) {
            if (key.getKeyCode() != keyCode) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onKeyPressed(int keyCode, IKeyboard.KeyPressedListener listener) {
        this.keySpecificPressedListener.computeIfAbsent(keyCode, ConcurrentHashMap::newKeySet).add(listener);
    }

    @Override
    public void removeKeyPressedListener(int keyCode, IKeyboard.KeyPressedListener listener) {
        if (!this.keySpecificPressedListener.containsKey(keyCode)) {
            return;
        }
        this.keySpecificPressedListener.get(keyCode).remove(listener);
    }

    @Override
    public void onKeyReleased(int keyCode, IKeyboard.KeyReleasedListener listener) {
        this.keySpecificReleasedListener.computeIfAbsent(keyCode, ConcurrentHashMap::newKeySet).add(listener);
    }

    @Override
    public void removeKeyReleasedListener(int keyCode, IKeyboard.KeyReleasedListener listener) {
        if (!this.keySpecificReleasedListener.containsKey(keyCode)) {
            return;
        }
        this.keySpecificReleasedListener.get(keyCode).remove(listener);
    }

    @Override
    public void onKeyTyped(int keyCode, IKeyboard.KeyTypedListener listener) {
        this.keySpecificTypedListener.computeIfAbsent(keyCode, ConcurrentHashMap::newKeySet).add(listener);
    }

    @Override
    public void removeKeyTypedListener(int keyCode, IKeyboard.KeyTypedListener listener) {
        if (!this.keySpecificTypedListener.containsKey(keyCode)) {
            return;
        }
        this.keySpecificTypedListener.get(keyCode).remove(listener);
    }

    @Override
    public void onKeyPressed(IKeyboard.KeyPressedListener listener) {
        this.keyPressedListener.add(listener);
    }

    @Override
    public void removeKeyPressedListener(IKeyboard.KeyPressedListener listener) {
        this.keyPressedListener.remove(listener);
    }

    @Override
    public void onKeyReleased(IKeyboard.KeyReleasedListener listener) {
        this.keyReleasedListener.add(listener);
    }

    @Override
    public void removeKeyReleasedListener(IKeyboard.KeyReleasedListener listener) {
        this.keyReleasedListener.remove(listener);
    }

    @Override
    public void onKeyTyped(IKeyboard.KeyTypedListener listener) {
        this.keyTypedListener.add(listener);
    }

    @Override
    public void removeKeyTypedListener(IKeyboard.KeyTypedListener listener) {
        this.keyTypedListener.remove(listener);
    }

    @Override
    public void clearExplicitListeners() {
        this.keyPressedListener.clear();
        this.keySpecificPressedListener.clear();
        this.keyReleasedListener.clear();
        this.keySpecificReleasedListener.clear();
        this.keyTypedListener.clear();
        this.keySpecificTypedListener.clear();
    }

    @Override
    public void addKeyListener(KeyListener listener) {
        if (this.keyListeners.contains(listener)) {
            return;
        }
        this.keyListeners.add(listener);
    }

    @Override
    public void removeKeyListener(KeyListener listener) {
        this.keyListeners.remove(listener);
    }

    @Override
    public void update() {
        this.executePressedKeys();
        this.executeReleasedKeys();
        this.executeTypedKeys();
    }

    private void addPressedKey(KeyEvent keyCode) {
        if (this.pressedKeys.stream().anyMatch(key -> key.getKeyCode() == keyCode.getKeyCode())) {
            return;
        }
        this.pressedKeys.add(keyCode);
    }

    private void addReleasedKey(KeyEvent keyCode) {
        if (this.releasedKeys.stream().anyMatch(key -> key.getKeyCode() == keyCode.getKeyCode())) {
            return;
        }
        this.releasedKeys.add(keyCode);
    }

    private void addTypedKey(KeyEvent keyCode) {
        if (this.typedKeys.stream().anyMatch(key -> key.getKeyCode() == keyCode.getKeyCode())) {
            return;
        }
        this.typedKeys.add(keyCode);
    }

    private void executePressedKeys() {
        this.pressedKeys.forEach(key -> {
            ((Collection)this.keySpecificPressedListener.getOrDefault(key.getKeyCode(), Collections.emptySet())).forEach(listener -> listener.keyPressed((KeyEvent)key));
            this.keyPressedListener.forEach(listener -> listener.keyPressed((KeyEvent)key));
            this.keyListeners.forEach(listener -> listener.keyPressed((KeyEvent)key));
        });
    }

    private void executeReleasedKeys() {
        this.releasedKeys.forEach(key -> {
            ((Collection)this.keySpecificReleasedListener.getOrDefault(key.getKeyCode(), Collections.emptySet())).forEach(listener -> listener.keyReleased((KeyEvent)key));
            this.keyReleasedListener.forEach(listener -> listener.keyReleased((KeyEvent)key));
            this.keyListeners.forEach(listener -> listener.keyReleased((KeyEvent)key));
        });
        this.releasedKeys.clear();
    }

    private void executeTypedKeys() {
        this.typedKeys.forEach(key -> {
            ((Collection)this.keySpecificTypedListener.getOrDefault(key.getKeyCode(), Collections.emptySet())).forEach(listener -> listener.keyTyped((KeyEvent)key));
            this.keyTypedListener.forEach(listener -> listener.keyTyped((KeyEvent)key));
            this.keyListeners.forEach(listener -> listener.keyTyped((KeyEvent)key));
        });
        this.typedKeys.clear();
    }

    private void removePressedKey(KeyEvent keyCode) {
        for (KeyEvent removeKey : this.pressedKeys) {
            if (removeKey.getKeyCode() != keyCode.getKeyCode()) continue;
            this.pressedKeys.remove(removeKey);
            return;
        }
    }
}

