/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.input.GamepadEvent;
import de.gurkenlabs.litiengine.input.GamepadEvents;
import de.gurkenlabs.litiengine.input.Input;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;

public final class Gamepad
extends GamepadEvents
implements IUpdateable {
    private static final Map<String, Component.Identifier> components = new HashMap<String, Component.Identifier>();
    private final Controller controller;
    private final Collection<String> gamepadComponents;
    private final int id;
    private final Collection<String> pressedComponents;
    private float axisDeadzone = Game.config().input().getGamepadAxisDeadzone();
    private float triggerDeadzone = Game.config().input().getGamepadTriggerDeadzone();
    private String type;

    Gamepad(int index, Controller controller) {
        this.pressedComponents = ConcurrentHashMap.newKeySet();
        this.id = index;
        this.controller = controller;
        ArrayList<String> componentNames = new ArrayList<String>();
        for (Component comp : this.controller.getComponents()) {
            componentNames.add(comp.getIdentifier().getName());
        }
        this.gamepadComponents = Collections.unmodifiableList(componentNames);
        this.type = Gamepad.guessGamepadType(this);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.controller.getName();
    }

    public float getPollData(String component) {
        if (components.containsKey(component)) {
            Component comp = this.controller.getComponent(components.get(component));
            if (comp == null) {
                return 0.0f;
            }
            return comp.getPollData();
        }
        return 0.0f;
    }

    public float getAxisDeadzone() {
        return this.axisDeadzone;
    }

    public float getTriggerDeadzone() {
        return this.triggerDeadzone;
    }

    @Override
    public boolean isPressed(String gamepadComponent) {
        return this.pressedComponents.stream().anyMatch(x -> x.equals(gamepadComponent));
    }

    public Collection<String> getComponents() {
        return this.gamepadComponents;
    }

    public boolean hasComponent(String gamepadComponent) {
        for (Component comp : this.controller.getComponents()) {
            if (!comp.getIdentifier().getName().equals(gamepadComponent)) continue;
            return true;
        }
        return false;
    }

    public void setAxisDeadzone(float axisDeadzone) {
        this.axisDeadzone = axisDeadzone;
    }

    public void setTriggerDeadzone(float triggerDeadzone) {
        this.triggerDeadzone = triggerDeadzone;
    }

    @Override
    public void update() {
        boolean couldPoll = this.controller.poll();
        if (!couldPoll) {
            this.dispose();
        }
        Event event = new Event();
        while (this.controller.getEventQueue().getNextEvent(event)) {
            this.handlePollEvents(event);
        }
        for (Component comp : this.controller.getComponents()) {
            if (Math.abs(comp.getPollData()) > this.getDeadZone(comp.getIdentifier())) {
                this.handlePressed(comp);
                continue;
            }
            this.handleRelease(comp);
        }
    }

    public String toString() {
        return "Gamepad " + this.getId() + " - " + this.controller.toString();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private static String guessGamepadType(Gamepad gamepad) {
        int xboxComponents = 0;
        for (String string : Xbox.ALL_COMPONENTS) {
            if (!gamepad.hasComponent(string)) continue;
            ++xboxComponents;
        }
        double xboxScore = (double)xboxComponents / (double)Xbox.ALL_COMPONENTS.length;
        if (gamepad.getName().toUpperCase().contains("XBOX")) {
            xboxScore += 1.0;
        }
        int dualShockComponents = 0;
        for (String comp : DualShock4.ALL_COMPONENTS) {
            if (!gamepad.hasComponent(comp)) continue;
            ++dualShockComponents;
        }
        double d = (double)dualShockComponents / (double)DualShock4.ALL_COMPONENTS.length;
        if (gamepad.getName().toUpperCase().contains("WIRELESS CONTROLLER")) {
            d += 0.3;
        }
        if (xboxScore < 0.5 && d < 0.5) {
            return "Unknown";
        }
        if (xboxScore > d) {
            return "Xbox";
        }
        return "DualShock4";
    }

    private static String addComponent(Component.Identifier identifier) {
        components.put(identifier.getName(), identifier);
        return identifier.getName();
    }

    private void handlePressed(Component comp) {
        String name = comp.getIdentifier().getName();
        GamepadEvent event = new GamepadEvent(this, comp);
        for (GamepadEvents.GamepadPressedListener listener : this.pressedListeners) {
            listener.pressed(event);
        }
        if (this.componentPressedListeners.containsKey(name)) {
            for (GamepadEvents.GamepadPressedListener listener : (Collection)this.componentPressedListeners.get(name)) {
                listener.pressed(event);
            }
        }
        if (!this.pressedComponents.contains(name)) {
            this.pressedComponents.add(name);
        }
    }

    private float getDeadZone(Component.Identifier ident) {
        if (ident.getName().equals(Axis.X) || ident.getName().equals(Axis.Y) || ident.getName().equals(Axis.RX) || ident.getName().equals(Axis.RY)) {
            return this.getAxisDeadzone();
        }
        if (ident.getName().equals(Axis.Z)) {
            return this.getTriggerDeadzone();
        }
        return 0.0f;
    }

    private void dispose() {
        this.componentPollListeners.clear();
        this.componentPressedListeners.clear();
        Input.gamepads().remove(this);
    }

    private void handlePollEvents(Event event) {
        GamepadEvent gamepadEvent = new GamepadEvent(this, event.getComponent());
        for (GamepadEvents.GamepadPollListener listener : this.pollListeners) {
            listener.polled(gamepadEvent);
        }
        Collection listeners = (Collection)this.componentPollListeners.get(event.getComponent().getIdentifier().getName());
        if (listeners != null) {
            for (GamepadEvents.GamepadPollListener listener : listeners) {
                listener.polled(gamepadEvent);
            }
        }
    }

    private void handleRelease(Component comp) {
        String name = comp.getIdentifier().getName();
        if (!this.pressedComponents.contains(name)) {
            return;
        }
        this.pressedComponents.remove(name);
        GamepadEvent event = new GamepadEvent(this, comp);
        for (GamepadEvents.GamepadReleasedListener listener : this.releasedListeners) {
            listener.released(event);
        }
        Collection listeners = (Collection)this.componentReleasedListeners.get(comp.getIdentifier().getName());
        if (listeners != null) {
            for (GamepadEvents.GamepadReleasedListener listener : listeners) {
                listener.released(event);
            }
        }
    }

    public static class Xbox {
        public static final String A = Buttons.BUTTON_0;
        public static final String B = Buttons.BUTTON_1;
        public static final String DPAD = Axis.POV;
        public static final String LB = Buttons.BUTTON_4;
        public static final String LEFT_STICK_PRESS = Buttons.BUTTON_8;
        public static final String LEFT_STICK_X = Axis.X;
        public static final String LEFT_STICK_Y = Axis.Y;
        public static final String LT = Axis.Z;
        public static final String RB = Buttons.BUTTON_5;
        public static final String RIGHT_STICK_PRESS = Buttons.BUTTON_9;
        public static final String RIGHT_STICK_X = Axis.RX;
        public static final String RIGHT_STICK_Y = Axis.RY;
        public static final String RT = Axis.Z;
        public static final String SELECT = Buttons.BUTTON_6;
        public static final String START = Buttons.BUTTON_7;
        public static final String X = Buttons.BUTTON_2;
        public static final String Y = Buttons.BUTTON_3;
        protected static final String[] ALL_COMPONENTS = new String[]{A, B, DPAD, LB, LEFT_STICK_PRESS, LEFT_STICK_X, LEFT_STICK_Y, LT, RB, RIGHT_STICK_PRESS, RIGHT_STICK_X, RIGHT_STICK_Y, RT, SELECT, START, X, Y};
        public static final String GAMEPAD_TYPE = "Xbox";

        private Xbox() {
        }
    }

    public static class DualShock4 {
        public static final String SQUARE = Buttons.BUTTON_0;
        public static final String CROSS = Buttons.BUTTON_1;
        public static final String CIRCLE = Buttons.BUTTON_2;
        public static final String TRIANGLE = Buttons.BUTTON_3;
        public static final String L1 = Buttons.BUTTON_4;
        public static final String R1 = Buttons.BUTTON_5;
        public static final String L2 = Buttons.BUTTON_6;
        public static final String R2 = Buttons.BUTTON_7;
        public static final String SHARE = Buttons.BUTTON_8;
        public static final String OPTIONS = Buttons.BUTTON_9;
        public static final String LEFT_STICK_PRESS = Buttons.BUTTON_10;
        public static final String RIGHT_STICK_PRESS = Buttons.BUTTON_11;
        public static final String PS_BUTTON = Buttons.BUTTON_12;
        public static final String TOUCHPAD = Buttons.BUTTON_13;
        public static final String DPAD = Axis.POV;
        public static final String LEFT_STICK_X = Axis.X;
        public static final String LEFT_STICK_Y = Axis.Y;
        public static final String RIGHT_STICK_X = Axis.Z;
        public static final String RIGHT_STICK_Y = Axis.RZ;
        public static final String R2_TRIGGER = Axis.RY;
        public static final String L2_TRIGGER = Axis.RX;
        protected static final String[] ALL_COMPONENTS = new String[]{SQUARE, CROSS, CIRCLE, TRIANGLE, L1, R1, L2, R2, SHARE, OPTIONS, LEFT_STICK_PRESS, RIGHT_STICK_PRESS, PS_BUTTON, TOUCHPAD, DPAD, LEFT_STICK_X, LEFT_STICK_Y, RIGHT_STICK_X, RIGHT_STICK_Y, R2_TRIGGER, L2_TRIGGER};
        public static final String GAMEPAD_TYPE = "DualShock4";

        private DualShock4() {
        }
    }

    public static class Axis {
        public static final String POV = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.POV);
        public static final String RX = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RX);
        public static final String RX_ACCELERATION = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RX_ACCELERATION);
        public static final String RX_FORCE = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RX_FORCE);
        public static final String RX_VELOCITY = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RX_VELOCITY);
        public static final String RY = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RY);
        public static final String RY_ACCELERATION = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RY_ACCELERATION);
        public static final String RY_FORCE = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RY_FORCE);
        public static final String RY_VELOCITY = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RY_VELOCITY);
        public static final String RZ = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RZ);
        public static final String RZ_ACCELERATION = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RZ_ACCELERATION);
        public static final String RZ_FORCE = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RZ_FORCE);
        public static final String RZ_VELOCITY = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.RZ_VELOCITY);
        public static final String SLIDER = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.SLIDER);
        public static final String SLIDER_ACCELERATION = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.SLIDER_ACCELERATION);
        public static final String SLIDER_FORCE = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.SLIDER_FORCE);
        public static final String SLIDER_VELOCITY = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.SLIDER_VELOCITY);
        public static final String X = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.X);
        public static final String X_ACCELERATION = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.X_ACCELERATION);
        public static final String X_FORCE = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.X_FORCE);
        public static final String X_VELOCITY = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.X_VELOCITY);
        public static final String Y = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.Y);
        public static final String Y_ACCELERATION = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.Y_ACCELERATION);
        public static final String Y_FORCE = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.Y_FORCE);
        public static final String Y_VELOCITY = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.Y_VELOCITY);
        public static final String Z = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.Z);
        public static final String Z_ACCELERATION = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.Z_ACCELERATION);
        public static final String Z_FORCE = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.Z_FORCE);
        public static final String Z_VELOCITY = Gamepad.addComponent((Component.Identifier)Component.Identifier.Axis.Z_VELOCITY);

        private Axis() {
        }
    }

    public static class DPad {
        public static final float OFF = 0.0f;
        public static final float CENTER = 0.0f;
        public static final float DOWN = 0.75f;
        public static final float DOWN_LEFT = 0.875f;
        public static final float DOWN_RIGHT = 0.625f;
        public static final float LEFT = 1.0f;
        public static final float RIGHT = 0.5f;
        public static final float UP = 0.25f;
        public static final float UP_LEFT = 0.125f;
        public static final float UP_RIGHT = 0.375f;

        private DPad() {
        }
    }

    public static class Buttons {
        public static final String BUTTON_0 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._0);
        public static final String BUTTON_1 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._1);
        public static final String BUTTON_10 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._10);
        public static final String BUTTON_11 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._11);
        public static final String BUTTON_12 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._12);
        public static final String BUTTON_13 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._13);
        public static final String BUTTON_14 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._14);
        public static final String BUTTON_15 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._15);
        public static final String BUTTON_16 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._16);
        public static final String BUTTON_17 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._17);
        public static final String BUTTON_18 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._18);
        public static final String BUTTON_19 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._19);
        public static final String BUTTON_2 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._2);
        public static final String BUTTON_20 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._20);
        public static final String BUTTON_21 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._21);
        public static final String BUTTON_22 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._22);
        public static final String BUTTON_23 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._23);
        public static final String BUTTON_24 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._24);
        public static final String BUTTON_25 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._25);
        public static final String BUTTON_26 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._26);
        public static final String BUTTON_27 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._27);
        public static final String BUTTON_28 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._28);
        public static final String BUTTON_29 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._29);
        public static final String BUTTON_3 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._3);
        public static final String BUTTON_30 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._30);
        public static final String BUTTON_31 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._31);
        public static final String BUTTON_4 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._4);
        public static final String BUTTON_5 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._5);
        public static final String BUTTON_6 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._6);
        public static final String BUTTON_7 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._7);
        public static final String BUTTON_8 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._8);
        public static final String BUTTON_9 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button._9);
        public static final String A = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.A);
        public static final String B = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.B);
        public static final String BASE = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.BASE);
        public static final String BASE2 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.BASE2);
        public static final String BASE3 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.BASE3);
        public static final String BASE4 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.BASE4);
        public static final String BASE5 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.BASE5);
        public static final String BASE6 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.BASE6);
        public static final String C = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.C);
        public static final String LEFT_THUMB = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.LEFT_THUMB);
        public static final String LEFT_THUMB2 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.LEFT_THUMB2);
        public static final String LEFT_THUMB3 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.LEFT_THUMB3);
        public static final String MODE = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.MODE);
        public static final String PINKIE = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.PINKIE);
        public static final String RIGHT_THUMB = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.RIGHT_THUMB);
        public static final String RIGHT_THUMB2 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.RIGHT_THUMB2);
        public static final String RIGHT_THUMB3 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.RIGHT_THUMB3);
        public static final String SELECT = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.SELECT);
        public static final String START = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.START);
        public static final String THUMB = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.THUMB);
        public static final String THUMB2 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.THUMB2);
        public static final String TOP = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.TOP);
        public static final String TOP2 = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.TOP2);
        public static final String TRIGGER = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.TRIGGER);
        public static final String X = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.X);
        public static final String Y = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.Y);
        public static final String Z = Gamepad.addComponent((Component.Identifier)Component.Identifier.Button.Z);

        private Buttons() {
        }
    }
}

