/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextFieldComponent
extends ImageComponent {
    public static final String DOUBLE_FORMAT = "[-+]?[0-9]*\\.?[0-9]*([eE][-+]?[0-9]*)?";
    public static final String INTEGER_FORMAT = "[0-9]{1,10}";
    private static final Logger log = Logger.getLogger(TextFieldComponent.class.getName());
    private final List<Consumer<String>> changeConfirmedConsumers = new CopyOnWriteArrayList<Consumer<String>>();
    private boolean cursorVisible;
    private int flickerDelay = 300;
    private String format;
    private String cursor = "_";
    private String fullText;
    private long lastToggled;
    private int maxLength = 0;

    public TextFieldComponent(double x, double y, double width, double height, String text) {
        super(x, y, width, height, text);
        this.setText(text);
        Input.keyboard().onKeyTyped(this::handleTypedKey);
        this.onClicked(e -> {
            if (!this.isSelected()) {
                this.setSelected(true);
            }
        });
        Input.mouse().onClicked((MouseEvent e) -> {
            if (this.isSelected() && !this.getBoundingBox().contains(Input.mouse().getLocation())) {
                this.acceptInput();
            }
        });
        this.setTextAlign(Align.LEFT);
        this.setAutomaticLineBreaks(true);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String newCursor) {
        this.cursor = newCursor;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public String getText() {
        return this.fullText;
    }

    @Override
    public void setText(String text) {
        this.fullText = text;
    }

    @Override
    public String getTextToRender(Graphics2D g) {
        return this.isSelected() && this.cursorVisible ? super.getTextToRender(g) + this.getCursor() : super.getTextToRender(g) + "  ";
    }

    public void handleTypedKey(KeyEvent event) {
        if (!this.canHandleInput()) {
            return;
        }
        switch (event.getKeyCode()) {
            case 8: {
                this.handleBackSpace();
                break;
            }
            case 10: 
            case 27: {
                this.acceptInput();
                break;
            }
            default: {
                this.handleNormalTyping(event);
            }
        }
    }

    public boolean canHandleInput() {
        return !this.isSuspended() && this.isSelected() && this.isVisible() && this.isEnabled();
    }

    public void onChangeConfirmed(Consumer<String> cons) {
        this.changeConfirmedConsumers.add(cons);
    }

    @Override
    public void render(Graphics2D g) {
        super.render(g);
        if (this.isSelected() && Game.time().since(this.lastToggled) >= (long)this.flickerDelay) {
            this.cursorVisible = !this.cursorVisible;
            this.lastToggled = Game.time().now();
        }
    }

    public void setFlickerDelay(int flickerDelayMillis) {
        this.flickerDelay = flickerDelayMillis;
    }

    private void acceptInput() {
        this.setSelected(false);
        this.changeConfirmedConsumers.forEach(c -> c.accept(this.getText()));
        log.log(Level.INFO, "{0} typed into TextField with ComponentID {1}", new Object[]{this.getText(), this.getComponentId()});
    }

    private void handleBackSpace() {
        if (Input.keyboard().isPressed(16)) {
            while (this.getText().length() >= 1 && this.getText().charAt(this.getText().length() - 1) == ' ') {
                this.setText(this.getText().substring(0, this.getText().length() - 1));
            }
            while (this.getText().length() >= 1 && this.getText().charAt(this.getText().length() - 1) != ' ') {
                this.setText(this.getText().substring(0, this.getText().length() - 1));
            }
        } else if (this.getText().length() >= 1) {
            this.setText(this.getText().substring(0, this.getText().length() - 1));
        }
        if (this.isKnownNumericFormat() && (this.getText() == null || this.getText().isEmpty())) {
            this.setText("0");
        }
    }

    private void handleNormalTyping(KeyEvent event) {
        Pattern pat;
        Matcher mat;
        if (this.getMaxLength() > 0 && this.getText().length() >= this.getMaxLength()) {
            return;
        }
        char text = event.getKeyChar();
        if (text == '\uffff') {
            return;
        }
        if (this.getFormat() != null && !this.getFormat().isEmpty() && !(mat = (pat = Pattern.compile(this.getFormat())).matcher(this.getText() + text)).matches()) {
            return;
        }
        if (this.isKnownNumericFormat() && this.getText().equals("0")) {
            this.setText("");
        }
        this.setText(this.getText() + text);
    }

    private boolean isKnownNumericFormat() {
        return this.getFormat() != null && (this.getFormat().equals(INTEGER_FORMAT) || this.getFormat().equals(DOUBLE_FORMAT));
    }
}

