/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.TextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class FontIcon {
    private final Font font;
    private final String text;

    public FontIcon(Font font, char text) {
        this.font = font;
        this.text = String.valueOf(text);
    }

    public FontIcon(Font font, String unicode) {
        this.font = font;
        this.text = unicode;
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    public void render(Graphics2D g, Color color, float fontSize, double x, double y, boolean bold) {
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        g.setColor(color);
        if (bold) {
            g.setFont(this.getFont().deriveFont(1, fontSize));
        } else {
            g.setFont(this.getFont().deriveFont(fontSize));
        }
        TextRenderer.render(g, this.getText(), x, y);
        g.setColor(oldColor);
        g.setFont(oldFont);
    }
}

