/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.particles;

import de.gurkenlabs.litiengine.graphics.TextRenderer;
import de.gurkenlabs.litiengine.graphics.emitters.particles.Particle;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class TextParticle
extends Particle {
    private Font font;
    private final String text;

    public TextParticle(String text) {
        super(1.0f, 1.0f);
        this.text = text;
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void render(Graphics2D g, Point2D emitterOrigin) {
        if (this.getText() == null || this.getText().isEmpty()) {
            return;
        }
        Font oldFont = g.getFont();
        if (this.getFont() != null) {
            g.setFont(this.getFont());
        }
        FontMetrics fm = g.getFontMetrics();
        this.setWidth(fm.stringWidth(this.getText()));
        this.setHeight(g.getFont().getSize2D());
        Point2D renderLocation = this.getRenderLocation(emitterOrigin);
        AffineTransform rotate = AffineTransform.getRotateInstance(Math.toRadians(this.getAngle()), (double)this.getWidth() * 0.5, (double)this.getHeight() * 0.5);
        g.setFont(g.getFont().deriveFont(rotate));
        RenderingHints originalHints = g.getRenderingHints();
        g.setColor(new Color((float)this.getColor().getRed() / 255.0f, (float)this.getColor().getGreen() / 255.0f, (float)this.getColor().getBlue() / 255.0f, this.getOpacity()));
        if (this.isAntiAliased()) {
            TextRenderer.enableTextAntiAliasing(g);
        }
        g.drawString(this.text, (float)renderLocation.getX(), (float)renderLocation.getY());
        g.setFont(oldFont);
        g.setRenderingHints(originalHints);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public Rectangle2D getBoundingBox(Point2D origin) {
        return new Rectangle2D.Double(origin.getX() + (double)this.getX() - (double)(this.getWidth() / 2.0f), origin.getY() + (double)this.getY() - (double)this.getHeight() * 1.5, this.getWidth(), this.getHeight());
    }
}

