/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.animation;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.ILaunchable;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.animation.KeyFrame;
import de.gurkenlabs.litiengine.graphics.animation.KeyFrameListener;
import de.gurkenlabs.litiengine.resources.Resources;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Animation
implements IUpdateable,
ILaunchable {
    private final List<KeyFrameListener> listeners;
    public static final int DEFAULT_FRAME_DURATION = 120;
    private static final Logger log = Logger.getLogger(Animation.class.getName());
    private final List<KeyFrame> keyframes;
    private final String name;
    private Spritesheet spritesheet;
    private KeyFrame currentFrame;
    private long lastFrameUpdate;
    private KeyFrame firstFrame;
    private int frameDuration = 120;
    private boolean loop;
    private boolean paused;
    private boolean playing;

    public Animation(String spriteSheetName, boolean loop, boolean randomizeStart, int ... keyFrameDurations) {
        this(Resources.spritesheets().get(spriteSheetName), loop, randomizeStart, keyFrameDurations);
    }

    public Animation(Spritesheet spritesheet, boolean loop, boolean randomizeStart, int ... keyFrameDurations) {
        this(spritesheet.getName(), spritesheet, loop, randomizeStart, keyFrameDurations);
    }

    public Animation(Spritesheet spritesheet, boolean loop, int ... keyFrameDurations) {
        this(spritesheet.getName(), spritesheet, loop, keyFrameDurations);
    }

    public Animation(String name, Spritesheet spritesheet, boolean loop, boolean randomizeStart, int ... keyFrameDurations) {
        this(name, spritesheet, loop, keyFrameDurations);
        if (randomizeStart && !this.keyframes.isEmpty()) {
            this.firstFrame = Game.random().choose(this.getKeyframes());
        }
    }

    public Animation(String name, Spritesheet spritesheet, boolean loop, int ... keyFrameDurations) {
        this.name = name;
        this.spritesheet = spritesheet;
        this.loop = loop;
        this.keyframes = new ArrayList<KeyFrame>();
        this.listeners = new CopyOnWriteArrayList<KeyFrameListener>();
        if (spritesheet == null) {
            log.log(Level.WARNING, "no spritesheet defined for animation {0}", this.getName());
            return;
        }
        this.initKeyFrames(keyFrameDurations);
        if (this.getKeyframes().isEmpty()) {
            log.log(Level.WARNING, "No keyframes defined for animation {0} (spitesheet: {1})", new Object[]{this.getName(), spritesheet.getName()});
        }
    }

    public int getTotalDuration() {
        int duration = 0;
        for (KeyFrame keyFrame : this.getKeyframes()) {
            duration += keyFrame.getDuration();
        }
        return duration;
    }

    public String getName() {
        return this.name;
    }

    public Spritesheet getSpritesheet() {
        if (this.spritesheet != null && !this.spritesheet.isLoaded()) {
            log.log(Level.INFO, "Reloading spritesheet {0} for animation {1}", new Object[]{this.spritesheet.getName(), this.getName()});
            this.spritesheet = Resources.spritesheets().get(this.spritesheet.getName());
            this.initKeyFrames(new int[0]);
        }
        return this.spritesheet;
    }

    public boolean isLooping() {
        return this.loop;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isPlaying() {
        return !this.paused && !this.keyframes.isEmpty() && this.playing;
    }

    public void pause() {
        this.paused = true;
    }

    public void unpause() {
        this.paused = false;
    }

    public void setDurationForAllKeyFrames(int frameDuration) {
        this.frameDuration = frameDuration;
        for (KeyFrame keyFrame : this.getKeyframes()) {
            keyFrame.setDuration(this.frameDuration);
        }
    }

    public void setKeyFrameDurations(int ... keyFrameDurations) {
        if (keyFrameDurations.length == 0) {
            return;
        }
        for (int i = 0; i < this.getKeyframes().size(); ++i) {
            this.getKeyframes().get(i).setDuration(keyFrameDurations[i]);
        }
    }

    public int[] getKeyFrameDurations() {
        return this.getKeyframes().stream().mapToInt(KeyFrame::getDuration).toArray();
    }

    public void setLooping(boolean loop) {
        this.loop = loop;
    }

    public void onKeyFrameChanged(KeyFrameListener listener) {
        this.listeners.add(listener);
    }

    public void removeKeyFrameListener(KeyFrameListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void start() {
        this.playing = true;
        if (this.getKeyframes().isEmpty()) {
            return;
        }
        this.restart();
    }

    public void restart() {
        this.currentFrame = this.firstFrame;
        this.lastFrameUpdate = Game.loop().getTicks();
    }

    @Override
    public void terminate() {
        this.playing = false;
        if (this.getKeyframes().isEmpty()) {
            return;
        }
        this.currentFrame = this.getKeyframes().get(0);
    }

    @Override
    public void update() {
        if (!this.isPlaying() || Game.time().since(this.lastFrameUpdate) < (long)this.getCurrentKeyFrame().getDuration()) {
            return;
        }
        if (!this.isLooping() && this.isLastKeyFrame()) {
            this.terminate();
            return;
        }
        int newFrameIndex = (this.getKeyframes().indexOf(this.currentFrame) + 1) % this.getKeyframes().size();
        KeyFrame previousFrame = this.currentFrame;
        this.currentFrame = this.getKeyframes().get(newFrameIndex);
        for (KeyFrameListener listener : this.listeners) {
            listener.currentFrameChanged(previousFrame, this.currentFrame);
        }
        this.lastFrameUpdate = Game.loop().getTicks();
    }

    public KeyFrame getCurrentKeyFrame() {
        return this.currentFrame;
    }

    public List<KeyFrame> getKeyframes() {
        return this.keyframes;
    }

    private void initKeyFrames(int ... durations) {
        if (this.getSpritesheet() == null) {
            return;
        }
        this.keyframes.clear();
        int[] keyFrameDurations = durations;
        if (keyFrameDurations.length == 0) {
            keyFrameDurations = Resources.spritesheets().getCustomKeyFrameDurations(this.name);
        }
        if (keyFrameDurations.length == 0) {
            for (int i = 0; i < this.getSpritesheet().getTotalNumberOfSprites(); ++i) {
                this.keyframes.add(i, new KeyFrame(this.frameDuration, i));
            }
        } else {
            for (int i = 0; i < keyFrameDurations.length; ++i) {
                this.keyframes.add(i, new KeyFrame(keyFrameDurations[i], i));
            }
        }
        if (!this.keyframes.isEmpty()) {
            this.firstFrame = this.getKeyframes().get(0);
        }
    }

    public boolean isLastKeyFrame() {
        return this.getKeyframes().indexOf(this.currentFrame) == this.getKeyframes().size() - 1;
    }
}

