/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities.behavior;

import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.behavior.State;
import de.gurkenlabs.litiengine.entities.behavior.Transition;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class StateMachine
implements IUpdateable {
    private State currentState;

    public State getCurrentState() {
        return this.currentState;
    }

    public void setState(State newState) {
        if (this.currentState != null) {
            this.currentState.exit();
        }
        this.currentState = newState;
        this.currentState.enter();
    }

    @Override
    public void update() {
        if (this.currentState == null) {
            return;
        }
        this.currentState.perform();
        List<Transition> transitions = this.currentState.getTransitions();
        Collections.sort(transitions);
        Optional<Transition> transition = transitions.stream().filter(Transition::conditionsFullfilled).findFirst();
        if (transition.isPresent()) {
            this.currentState.exit();
            this.setState(transition.get().getNextState());
            this.currentState.enter();
        }
    }
}

