/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities.behavior;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.entities.behavior.Path;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;

public abstract class PathFinder {
    private static final float PATH_MARGIN = 2.0f;

    public abstract Path findPath(IMobileEntity var1, Point2D var2);

    protected Path findDirectPath(Point2D start, Point2D target) {
        GeneralPath path2D = new GeneralPath(1);
        ((Path2D)path2D).moveTo(start.getX(), start.getY());
        ((Path2D)path2D).lineTo(target.getX(), target.getY());
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(start);
        points.add(target);
        return new Path(start, target, path2D, points);
    }

    protected Rectangle2D applyPathMargin(ICollisionEntity entity, Rectangle2D rectangle) {
        double newX = rectangle.getX() - (entity.getCollisionBox().getWidth() * 0.5 + 2.0);
        double newY = rectangle.getY() - (entity.getCollisionBox().getHeight() * 0.5 + 2.0);
        double newWidth = rectangle.getWidth() + entity.getCollisionBox().getWidth() + 4.0;
        double newHeight = rectangle.getHeight() + entity.getCollisionBox().getHeight() + 4.0;
        return new Rectangle2D.Double(newX, newY, newWidth, newHeight);
    }

    protected boolean intersectsWithAnyCollisionBox(ICollisionEntity entity, Point2D start, Point2D target) {
        Collection<Rectangle2D> allCollisionBoxes = Game.physics().getCollisionBoxes();
        Line2D.Double line = new Line2D.Double(start, target);
        for (Rectangle2D collisionBox : allCollisionBoxes) {
            Rectangle2D rectangleWithMargin;
            Point2D intersection;
            if (collisionBox.equals(entity.getCollisionBox()) || (intersection = GeometricUtilities.getIntersectionPoint((Line2D)line, (rectangleWithMargin = this.applyPathMargin(entity, collisionBox)).contains(start) ? collisionBox : rectangleWithMargin)) == null) continue;
            return true;
        }
        return false;
    }
}

