/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.entities.CollisionBox;
import de.gurkenlabs.litiengine.entities.EntityInfo;
import de.gurkenlabs.litiengine.entities.MapArea;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.StaticShadowType;
import java.awt.Color;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

@EntityInfo(renderType=RenderType.OVERLAY)
public class StaticShadow
extends MapArea {
    public static final Color DEFAULT_COLOR = new Color(0, 0, 0, 75);
    public static final int DEFAULT_OFFSET = 10;
    @TmxProperty(name="shadowType")
    private StaticShadowType shadowType;
    @TmxProperty(name="shadowOffset")
    private int shadowOffset;
    private final CollisionBox origin;
    private Area area;

    public StaticShadow(StaticShadowType shadowType, int offset) {
        this.shadowType = shadowType;
        this.shadowOffset = offset;
        this.origin = null;
    }

    public StaticShadow(StaticShadowType shadowType) {
        this.shadowType = shadowType;
        this.shadowOffset = 10;
        this.origin = null;
    }

    public StaticShadow(double x, double y, float width, float height, StaticShadowType shadowType) {
        this(0, null, x, y, width, height, shadowType);
    }

    public StaticShadow(int id, double x, double y, float width, float height, StaticShadowType shadowType) {
        this(id, null, x, y, width, height, shadowType);
    }

    public StaticShadow(int id, String name, double x, double y, float width, float height, StaticShadowType shadowType) {
        super(id, name, x, y, width, height);
        this.setShadowType(shadowType);
        this.origin = null;
        this.shadowOffset = 10;
    }

    public StaticShadow(CollisionBox collisionBox) {
        super(0, null, collisionBox.getX(), collisionBox.getY(), collisionBox.getWidth(), collisionBox.getHeight());
        this.setShadowType(StaticShadowType.NONE);
        this.origin = collisionBox;
        this.shadowOffset = 10;
    }

    public StaticShadowType getShadowType() {
        return this.shadowType;
    }

    public void setShadowType(StaticShadowType shadowType) {
        this.shadowType = shadowType;
        this.area = null;
    }

    @Override
    public void setX(double x) {
        super.setX(x);
        this.area = null;
    }

    @Override
    public void setY(double y) {
        super.setY(y);
        this.area = null;
    }

    @Override
    public void setWidth(double width) {
        super.setWidth(width);
        this.area = null;
    }

    @Override
    public void setHeight(double height) {
        super.setHeight(height);
        this.area = null;
    }

    @Override
    public void setLocation(Point2D location) {
        super.setLocation(location);
        this.area = null;
    }

    public CollisionBox getOrigin() {
        return this.origin;
    }

    @Override
    public String toString() {
        if (this.getOrigin() == null) {
            return super.toString();
        }
        return "[" + this.getOrigin().toString() + "] -> " + super.toString();
    }

    public Area getArea() {
        if (this.getShadowType() == StaticShadowType.NONE) {
            return null;
        }
        if (this.area == null) {
            this.createArea();
        }
        return this.area;
    }

    private void createArea() {
        if (this.getShadowType() == StaticShadowType.NONE) {
            return;
        }
        Path2D.Double parallelogram = new Path2D.Double();
        double right = this.getX() + this.getWidth();
        double bottom = this.getY() + this.getHeight();
        double halfOffset = (double)this.getOffset() / 2.0;
        ((Path2D)parallelogram).moveTo(this.getX(), this.getY());
        ((Path2D)parallelogram).lineTo(right, this.getY());
        switch (this.shadowType) {
            case DOWN: {
                ((Path2D)parallelogram).lineTo(right, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX(), bottom + (double)this.getOffset());
                break;
            }
            case DOWNLEFT: {
                ((Path2D)parallelogram).lineTo(right, bottom);
                ((Path2D)parallelogram).lineTo(right - halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX(), bottom + (double)this.getOffset());
                break;
            }
            case DOWNRIGHT: {
                ((Path2D)parallelogram).lineTo(right, bottom);
                ((Path2D)parallelogram).lineTo(right + halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX(), bottom + (double)this.getOffset());
                break;
            }
            case LEFT: {
                ((Path2D)parallelogram).lineTo(right, bottom);
                ((Path2D)parallelogram).lineTo(right - halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX() - halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX(), bottom);
                break;
            }
            case LEFTDOWN: {
                ((Path2D)parallelogram).lineTo(right, bottom);
                ((Path2D)parallelogram).lineTo(right, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX() - halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX(), bottom);
                break;
            }
            case LEFTRIGHT: {
                ((Path2D)parallelogram).lineTo(right, bottom);
                ((Path2D)parallelogram).lineTo(right + halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX() - halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX(), bottom);
                break;
            }
            case NONE: {
                break;
            }
            case NOOFFSET: {
                ((Path2D)parallelogram).lineTo(right, bottom);
                ((Path2D)parallelogram).lineTo(this.getX(), bottom);
                break;
            }
            case RIGHT: {
                ((Path2D)parallelogram).lineTo(right, bottom);
                ((Path2D)parallelogram).lineTo(right + halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX() + halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX(), bottom);
                break;
            }
            case RIGHTDOWN: {
                ((Path2D)parallelogram).lineTo(right, bottom);
                ((Path2D)parallelogram).lineTo(right, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX() + halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX(), bottom);
                break;
            }
            case RIGHTLEFT: {
                ((Path2D)parallelogram).lineTo(right, bottom);
                ((Path2D)parallelogram).lineTo(right - halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX() + halfOffset, bottom + (double)this.getOffset());
                ((Path2D)parallelogram).lineTo(this.getX(), bottom);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected shadow type: " + String.valueOf((Object)this.shadowType));
            }
        }
        parallelogram.closePath();
        this.area = new Area(parallelogram);
    }

    public int getOffset() {
        return this.shadowOffset;
    }

    public void setOffset(int shadowOffset) {
        this.shadowOffset = shadowOffset;
        this.area = null;
    }
}

