/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.attributes.Attribute;
import de.gurkenlabs.litiengine.entities.EntityMovedEvent;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.physics.IMovementController;
import java.util.EventListener;

public interface IMobileEntity
extends ICollisionEntity {
    public void onMoved(EntityMovedListener var1);

    public void removeMovedListener(EntityMovedListener var1);

    public int getAcceleration();

    default public double getAcceleration(double deltaTime) {
        float maxPixelsPerTick = this.getTickVelocity();
        int acceleration = this.getAcceleration();
        return acceleration == 0 ? (double)maxPixelsPerTick : deltaTime / (double)acceleration * (double)maxPixelsPerTick;
    }

    public int getDeceleration();

    default public double getDeceleration(double deltaTime, double velocity) {
        float maxPixelsPerTick = this.getTickVelocity();
        int deceleration = this.getDeceleration();
        return deceleration == 0 ? velocity : deltaTime / (double)deceleration * (double)maxPixelsPerTick;
    }

    public Attribute<Float> getVelocity();

    public float getTickVelocity();

    public IMovementController movement();

    public void setAcceleration(int var1);

    public void setDeceleration(int var1);

    public void setTurnOnMove(boolean var1);

    public void setVelocity(float var1);

    public boolean turnOnMove();

    @FunctionalInterface
    public static interface EntityMovedListener
    extends EventListener {
        public void moved(EntityMovedEvent var1);
    }
}

