/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.configuration;

import de.gurkenlabs.litiengine.configuration.ConfigurationGroup;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroupInfo;
import java.util.Locale;

@ConfigurationGroupInfo(prefix="cl_")
public class ClientConfiguration
extends ConfigurationGroup {
    private String country;
    private String language;
    private int maxFps;
    private boolean showGameMetrics;
    private boolean exitOnError;

    ClientConfiguration() {
        this.setMaxFps(60);
        this.setShowGameMetrics(false);
        this.setExitOnError(false);
        this.setLanguage(Locale.getDefault().getLanguage());
        this.setCountry(Locale.getDefault().getCountry());
    }

    public String getCountry() {
        return this.country;
    }

    public String getLanguage() {
        return this.language;
    }

    public Locale getLocale() {
        if (this.getCountry() == null || this.getCountry().isEmpty()) {
            return Locale.of(this.getLanguage());
        }
        return Locale.of(this.getLanguage(), this.getCountry());
    }

    public int getMaxFps() {
        return this.maxFps;
    }

    public void setCountry(String country) {
        this.set("country", country);
    }

    public void setLanguage(String language) {
        this.set("language", language);
    }

    public void setMaxFps(int maxFps) {
        this.set("maxFps", Math.max(1, maxFps));
    }

    public void setShowGameMetrics(boolean showGameMetrics) {
        this.set("showGameMetrics", showGameMetrics);
    }

    public void setExitOnError(boolean exit) {
        this.set("exitOnError", exit);
    }

    public boolean showGameMetrics() {
        return this.showGameMetrics;
    }

    public boolean exitOnError() {
        return this.exitOnError;
    }
}

