/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.configuration.DisplayMode;
import de.gurkenlabs.litiengine.graphics.MouseCursor;
import de.gurkenlabs.litiengine.graphics.RenderComponent;
import de.gurkenlabs.litiengine.gui.screens.Resolution;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public final class GameWindow {
    private static final Logger log = Logger.getLogger(GameWindow.class.getName());
    private static final int ICONIFIED_MAX_FPS = 1;
    private static final int NONE_FOCUS_MAX_FPS = 10;
    private final List<ResolutionChangedListener> resolutionChangedListeners;
    private final JFrame hostControl = new JFrame();
    private final RenderComponent renderCanvas;
    private final MouseCursor cursor;
    private float resolutionScale = 1.0f;
    private Dimension resolution;
    private Point screenLocation;

    GameWindow() {
        this.resolutionChangedListeners = new CopyOnWriteArrayList<ResolutionChangedListener>();
        this.renderCanvas = new RenderComponent(Game.config().graphics().getResolution());
        this.cursor = new MouseCursor();
        if (!Game.isInNoGUIMode()) {
            this.hostControl.setBackground(Color.BLACK);
            this.hostControl.add(this.renderCanvas);
            this.initializeEventListeners();
            this.hostControl.setTitle(Game.info().getTitle());
            this.hostControl.setDefaultCloseOperation(0);
            GameWindow.initializeWindowEventListeners(this.hostControl);
        }
    }

    public boolean isFocusOwner() {
        if (this.getRenderComponent() != null && this.getRenderComponent().isFocusOwner()) {
            return true;
        }
        return this.hostControl.isFocusOwner();
    }

    public void onResolutionChanged(ResolutionChangedListener listener) {
        this.resolutionChangedListeners.add(listener);
    }

    public void removeResolutionChangedListener(ResolutionChangedListener listener) {
        this.resolutionChangedListeners.remove(listener);
    }

    public void setResolution(Resolution res) {
        this.resolutionScale = GameWindow.setResolution(this.getHostControl(), res.getDimension());
    }

    public float getResolutionScale() {
        return this.resolutionScale;
    }

    public Point2D getCenter() {
        return new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
    }

    public Container getHostControl() {
        return this.hostControl;
    }

    public Dimension getSize() {
        return this.hostControl.getSize();
    }

    public int getWidth() {
        return this.hostControl.getWidth();
    }

    public int getHeight() {
        return this.hostControl.getHeight();
    }

    public RenderComponent getRenderComponent() {
        return this.renderCanvas;
    }

    public MouseCursor cursor() {
        return this.cursor;
    }

    public Dimension getResolution() {
        return this.resolution;
    }

    public Point getLocationOnScreen() {
        if (this.screenLocation != null) {
            return this.screenLocation;
        }
        this.screenLocation = this.hostControl.getLocationOnScreen();
        return this.screenLocation;
    }

    public void setIcon(Image image) {
        this.hostControl.setIconImage(image);
    }

    public void setIcons(List<? extends Image> images) {
        this.hostControl.setIconImages(images);
    }

    public void setTitle(String title) {
        this.hostControl.setTitle(title);
    }

    static void prepareHostControl(JFrame host, DisplayMode displaymode, Dimension resolution) {
        switch (displaymode) {
            case BORDERLESS: {
                host.setResizable(false);
                host.setUndecorated(true);
                host.setExtendedState(6);
                host.setVisible(true);
                resolution = new Dimension(host.getSize().width, host.getSize().height);
                break;
            }
            case FULLSCREEN: {
                GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                if (!gd.isFullScreenSupported()) {
                    log.log(Level.WARNING, "Full screen is not supported on this device. Falling back to borderless display mode.");
                    GameWindow.prepareHostControl(host, DisplayMode.BORDERLESS, resolution);
                    return;
                }
                gd.setFullScreenWindow(host);
                resolution = new Dimension(host.getSize().width, host.getSize().height);
                break;
            }
            default: {
                host.setVisible(true);
            }
        }
        GameWindow.setResolution(host, resolution);
    }

    void init() {
        if (Game.isInNoGUIMode()) {
            this.resolution = new Dimension(0, 0);
            this.hostControl.setVisible(false);
            return;
        }
        GameWindow.prepareHostControl(this.hostControl, Game.config().graphics().getDisplayMode(), Game.config().graphics().getResolution());
        this.getRenderComponent().init();
        this.resolution = this.getRenderComponent().getSize();
        this.hostControl.requestFocus();
    }

    private static float setResolution(Container host, Dimension dim) {
        Dimension insetAwareDimension = new Dimension(dim.width + host.getInsets().left + host.getInsets().right, dim.height + host.getInsets().top + host.getInsets().bottom);
        host.setSize(insetAwareDimension);
        return GameWindow.getUpdatedResolutionScale(dim);
    }

    private static float getUpdatedResolutionScale(Dimension dim) {
        float resolutionScale = 1.0f;
        if (Game.config().graphics().enableResolutionScaling()) {
            resolutionScale = (float)(dim.getWidth() / (double)Resolution.Ratio16x9.RES_1920x1080.getWidth());
        }
        return resolutionScale;
    }

    private void initializeEventListeners() {
        this.getRenderComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                GameWindow.this.resolution = GameWindow.this.getRenderComponent().getSize();
                GameWindow.this.resolutionScale = GameWindow.getUpdatedResolutionScale(GameWindow.this.getSize());
                GameWindow.this.resolutionChangedListeners.forEach(listener -> listener.resolutionChanged(GameWindow.this.getSize()));
            }
        });
        this.hostControl.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                GameWindow.this.screenLocation = null;
            }
        });
    }

    private static void initializeWindowEventListeners(Window window) {
        window.addWindowStateListener(e -> {
            if (e.getNewState() == 1) {
                Game.loop().setTickRate(1);
            } else {
                Game.loop().setTickRate(Game.config().client().getMaxFps());
            }
        });
        window.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (Game.config().graphics().reduceFramesWhenNotFocused()) {
                    Game.loop().setTickRate(10);
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                Game.loop().setTickRate(Game.config().client().getMaxFps());
            }
        });
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Game.exit();
            }
        });
    }

    @FunctionalInterface
    public static interface ResolutionChangedListener
    extends EventListener {
        public void resolutionChanged(Dimension var1);
    }
}

