/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.EnvironmentLoadedListener;

public final class GameTime
implements EnvironmentLoadedListener {
    private long environmentLoaded;

    GameTime() {
    }

    public long now() {
        return Game.loop().getTicks();
    }

    public long since(long tick) {
        return this.toMilliseconds(this.now() - tick, Game.loop().getTickRate());
    }

    public long since(long tick, int updateRate) {
        return this.toMilliseconds(this.now() - tick, updateRate);
    }

    public long sinceGameStart() {
        return this.toMilliseconds(Game.loop().getTicks());
    }

    public long sinceEnvironmentLoad() {
        return this.since(this.environmentLoaded);
    }

    public long toMilliseconds(long ticks) {
        return this.toMilliseconds(ticks, Game.loop().getTickRate());
    }

    public long toMilliseconds(long ticks, int updateRate) {
        if (updateRate == 0) {
            throw new ArithmeticException("/ by zero");
        }
        return (long)((double)ticks / ((double)updateRate / 1000.0));
    }

    public long toTicks(int milliseconds) {
        return this.toTicks(milliseconds, Game.loop().getTickRate());
    }

    public long toTicks(int milliseconds, int updateRate) {
        return (long)((double)updateRate / 1000.0 * (double)milliseconds);
    }

    @Override
    public void loaded(Environment environment) {
        this.environmentLoaded = Game.loop().getTicks();
    }
}

