/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.GameMetrics;
import de.gurkenlabs.litiengine.IGameLoop;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.UpdateLoop;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.input.Keyboard;
import de.gurkenlabs.litiengine.input.Mouse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class GameLoop
extends UpdateLoop
implements IGameLoop {
    public static final int TICK_DELTATIME_LAG = 67;
    private static int executionIndex = -1;
    private final List<TimedAction> actions = new CopyOnWriteArrayList<TimedAction>();
    private float timeScale;

    GameLoop(String name, int updateRate) {
        super(name, updateRate);
        this.setTimeScale(1.0f);
    }

    @Override
    public int perform(int delay, Runnable action) {
        long d = Game.time().toTicks(delay);
        TimedAction a = new TimedAction(this.getTicks() + d, action);
        this.actions.add(a);
        return a.getId();
    }

    @Override
    public float getTimeScale() {
        return this.timeScale;
    }

    @Override
    public void setTimeScale(float timeScale) {
        this.timeScale = timeScale;
    }

    @Override
    public void alterExecutionTime(int index, long ticks) {
        for (TimedAction action : this.actions) {
            if (action.getId() != index) continue;
            action.setExecutionTicks(ticks);
        }
    }

    @Override
    public void removeAction(int id) {
        this.actions.removeIf(x -> x.getId() == id);
    }

    @Override
    protected void process() {
        this.updateInvariableEngineComponents();
        if (this.getTimeScale() > 0.0f) {
            super.process();
            this.executeTimedActions();
        }
        Game.world().camera().updateFocus();
        if (!Game.isInNoGUIMode()) {
            Game.window().getRenderComponent().render();
        }
        this.trackRenderMetric();
    }

    @Override
    protected long getExpectedDelta() {
        float scale = this.getTimeScale() > 0.0f ? this.getTimeScale() : 1.0f;
        return (long)(1000.0f / ((float)this.getTickRate() * scale));
    }

    private void executeTimedActions() {
        ArrayList<TimedAction> executed = new ArrayList<TimedAction>();
        for (TimedAction action : this.actions) {
            if (action.getExecutionTick() > this.getTicks()) continue;
            action.getAction().run();
            executed.add(action);
        }
        this.actions.removeAll(executed);
    }

    private void trackRenderMetric() {
        Game.metrics().setEstimatedMaxFramesPerSecond((int)(1000.0 / this.getProcessTime()));
        if (Game.config().debug().trackRenderTimes()) {
            Game.metrics().trackRenderTime("total", this.getProcessTime(), new GameMetrics.RenderInfo[0]);
        }
    }

    private void updateInvariableEngineComponents() {
        Game.audio().update();
        ((Keyboard)Input.keyboard()).update();
        ((Mouse)Input.mouse()).update();
        if (Game.config().input().isGamepadSupport()) {
            for (IUpdateable iUpdateable : Input.gamepads().getAll()) {
                iUpdateable.update();
            }
        }
    }

    private static class TimedAction {
        private final Runnable action;
        private long execution;
        private final int id;

        private TimedAction(long execution, Runnable action) {
            this.execution = execution;
            this.action = action;
            this.id = ++executionIndex;
        }

        public Runnable getAction() {
            return this.action;
        }

        public long getExecutionTick() {
            return this.execution;
        }

        public void setExecutionTicks(long ticks) {
            this.execution = ticks;
        }

        public int getId() {
            return this.id;
        }
    }
}

