/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;

public class MathUtilities {
    private MathUtilities() {
        throw new UnsupportedOperationException();
    }

    public static boolean equals(double d1, double d2, double epsilon) {
        return Math.abs(d1 - d2) <= epsilon;
    }

    public static float round(float value, int places) {
        return (float)MathUtilities.round((double)value, places);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static double getAverage(double[] numbers) {
        return Arrays.stream(numbers).average().orElse(0.0);
    }

    public static float getAverage(float[] numbers) {
        float sum = 0.0f;
        for (float number : numbers) {
            if (number == 0.0f) continue;
            sum += number;
        }
        return sum / (float)numbers.length;
    }

    public static double getAverage(int[] numbers) {
        return Arrays.stream(numbers).average().orElse(0.0);
    }

    public static int getMax(int ... numbers) {
        return Arrays.stream(numbers).max().orElse(Integer.MIN_VALUE);
    }

    public static boolean isInt(double value) {
        return value == Math.floor(value) && !Double.isInfinite(value);
    }

    public static boolean isOddNumber(int num) {
        return (num & 1) != 0;
    }

    public static int getFullPercent(double value, double fraction) {
        if (value == 0.0) {
            return 0;
        }
        return (int)(fraction * 100.0 / value);
    }

    public static double getPercent(double value, double fraction) {
        if (value == 0.0) {
            return 0.0;
        }
        return (double)((float)fraction * 100.0f) / value;
    }
}

