/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.sound.SoundEngine;
import de.gurkenlabs.litiengine.sound.SoundEvent;
import de.gurkenlabs.litiengine.sound.SoundPlaybackListener;
import de.gurkenlabs.litiengine.tweening.TweenFunction;
import de.gurkenlabs.litiengine.tweening.TweenType;
import de.gurkenlabs.litiengine.tweening.Tweenable;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public abstract class SoundPlayback
implements Runnable {
    protected final SourceDataLine line;
    private final FloatControl gainControl;
    private final BooleanControl muteControl;
    private boolean started = false;
    private volatile boolean cancelled = false;
    private final Collection<SoundPlaybackListener> listeners = ConcurrentHashMap.newKeySet();
    private final Collection<VolumeControl> volumeControls = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final VolumeControl masterVolume;
    private final AtomicInteger miscVolume = new AtomicInteger(1065353216);

    SoundPlayback(AudioFormat format) throws LineUnavailableException {
        this.line = AudioSystem.getSourceDataLine(format);
        this.line.open();
        this.line.start();
        this.gainControl = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
        this.muteControl = (BooleanControl)this.line.getControl(BooleanControl.Type.MUTE);
        this.masterVolume = this.createVolumeControl();
    }

    public synchronized void start() {
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        this.play();
        this.started = true;
    }

    public void addSoundPlaybackListener(SoundPlaybackListener listener) {
        this.listeners.add(listener);
    }

    public void removeSoundPlaybackListener(SoundPlaybackListener listener) {
        this.listeners.remove(listener);
    }

    public void setPaused(boolean paused) {
        if (paused) {
            this.pausePlayback();
        } else {
            this.resumePlayback();
        }
    }

    public void pausePlayback() {
        if (this.line.isOpen()) {
            this.line.stop();
        }
    }

    public void resumePlayback() {
        if (this.line.isOpen()) {
            this.line.start();
        }
    }

    public void fade(int duration) {
        this.fade(duration, 0.0f, TweenFunction.LINEAR);
    }

    public void fade(int duration, float target, TweenFunction easingType) {
        for (VolumeControl v : this.getVolumeControls()) {
            Game.tweens().begin(v, TweenType.VOLUME, duration).target(target).ease(easingType);
        }
    }

    public boolean isPaused() {
        return !this.line.isActive();
    }

    public boolean isPlaying() {
        return this.line.isOpen();
    }

    public synchronized void cancel() {
        if (!this.started) {
            throw new IllegalStateException("not started");
        }
        if (!this.cancelled && this.line.isOpen()) {
            this.line.stop();
            this.cancelled = true;
            this.line.flush();
            SoundEvent event = new SoundEvent(this, null);
            for (SoundPlaybackListener listener : this.listeners) {
                listener.cancelled(event);
            }
        }
    }

    public float getMasterVolume() {
        if (this.muteControl.getValue()) {
            return 0.0f;
        }
        return (float)Math.pow(10.0, (double)this.gainControl.getValue() / 20.0);
    }

    public float getVolume() {
        return this.masterVolume.get();
    }

    public void setVolume(float volume) {
        this.masterVolume.set(volume);
    }

    public VolumeControl createVolumeControl() {
        VolumeControl control = new VolumeControl();
        this.volumeControls.add(control);
        return control;
    }

    public Collection<VolumeControl> getVolumeControls() {
        return this.volumeControls;
    }

    void play() {
        SoundEngine.EXECUTOR.submit(this);
    }

    boolean play(Sound sound) throws LineUnavailableException {
        this.line.open();
        this.line.start();
        byte[] data = sound.getStreamData();
        int len = this.line.getFormat().getFrameSize();
        len = (this.line.getBufferSize() / len / 2 + 1) * len;
        for (int i = 0; i < data.length; i += this.line.write(data, i, Math.min(len, data.length - i))) {
            if (!this.cancelled && this.line.isOpen()) continue;
            return true;
        }
        return this.cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish() {
        this.line.drain();
        SoundPlayback soundPlayback = this;
        synchronized (soundPlayback) {
            this.cancel();
            if (!this.cancelled) {
                SoundEvent event = new SoundEvent(this, null);
                for (SoundPlaybackListener listener : this.listeners) {
                    listener.finished(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateVolume() {
        Collection<VolumeControl> collection = this.volumeControls;
        synchronized (collection) {
            float volume = Float.intBitsToFloat(this.miscVolume.get());
            for (VolumeControl control : this.volumeControls) {
                volume *= control.get();
            }
            float dbGain = (float)(20.0 * Math.log10(volume));
            if (dbGain < this.gainControl.getMinimum()) {
                this.muteControl.setValue(true);
            } else {
                this.gainControl.setValue(dbGain);
                this.muteControl.setValue(false);
            }
        }
    }

    public class VolumeControl
    implements Tweenable,
    AutoCloseable {
        private volatile float value = 1.0f;

        private VolumeControl() {
        }

        public float get() {
            return this.value;
        }

        public void set(float value) {
            if (value < 0.0f) {
                throw new IllegalArgumentException("negative volume");
            }
            this.value = value;
            SoundPlayback.this.updateVolume();
        }

        @Override
        public void close() {
            SoundPlayback.this.miscVolume.accumulateAndGet(Float.floatToRawIntBits(this.value), (a, b) -> Float.floatToRawIntBits(Float.intBitsToFloat(a) * Float.intBitsToFloat(b)));
        }

        @Override
        public float[] getTweenValues(TweenType tweenType) {
            float[] fArray;
            switch (tweenType) {
                case VOLUME: {
                    float[] fArray2 = new float[1];
                    fArray = fArray2;
                    fArray2[0] = this.get();
                    break;
                }
                default: {
                    fArray = Tweenable.super.getTweenValues(tweenType);
                }
            }
            return fArray;
        }

        @Override
        public void setTweenValues(TweenType tweenType, float[] newValues) {
            if (Objects.requireNonNull(tweenType) == TweenType.VOLUME) {
                this.set(newValues[0]);
            } else {
                Tweenable.super.setTweenValues(tweenType, newValues);
            }
        }
    }
}

