/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.resources;

import de.gurkenlabs.litiengine.environment.tilemap.xml.Tileset;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.emitters.xml.EmitterData;
import de.gurkenlabs.litiengine.graphics.emitters.xml.EmitterLoader;
import de.gurkenlabs.litiengine.resources.Blueprints;
import de.gurkenlabs.litiengine.resources.Fonts;
import de.gurkenlabs.litiengine.resources.Images;
import de.gurkenlabs.litiengine.resources.Maps;
import de.gurkenlabs.litiengine.resources.ResourceBundle;
import de.gurkenlabs.litiengine.resources.SoundResource;
import de.gurkenlabs.litiengine.resources.Sounds;
import de.gurkenlabs.litiengine.resources.SpritesheetResource;
import de.gurkenlabs.litiengine.resources.Spritesheets;
import de.gurkenlabs.litiengine.resources.Strings;
import de.gurkenlabs.litiengine.resources.Tilesets;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.util.TimeUtilities;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Resources {
    private static final Logger log = Logger.getLogger(Resources.class.getName());
    private static Fonts fonts = new Fonts();
    private static Sounds sounds = new Sounds();
    private static Maps maps = new Maps();
    private static Tilesets tilesets = new Tilesets();
    private static Strings strings = new Strings();
    private static Images images = new Images();
    private static Spritesheets spritesheets = new Spritesheets();
    private static Blueprints blueprints = new Blueprints();

    private Resources() {
        throw new UnsupportedOperationException();
    }

    public static Fonts fonts() {
        return fonts;
    }

    public static Sounds sounds() {
        return sounds;
    }

    public static Maps maps() {
        return maps;
    }

    public static Tilesets tilesets() {
        return tilesets;
    }

    public static Strings strings() {
        return strings;
    }

    public static Images images() {
        return images;
    }

    public static Spritesheets spritesheets() {
        return spritesheets;
    }

    public static Blueprints blueprints() {
        return blueprints;
    }

    public static void load(String gameResourceFile) {
        Resources.load(Resources.getLocation(gameResourceFile));
    }

    public static void load(URL gameResourceFile) {
        long loadStart = System.nanoTime();
        ResourceBundle file = ResourceBundle.load(gameResourceFile);
        if (file == null) {
            return;
        }
        file.getMaps().parallelStream().forEach(m -> Resources.maps().add(m.getName(), m));
        log.log(Level.INFO, "{0} maps loaded from {1}", new Object[]{file.getMaps().size(), gameResourceFile});
        file.getBluePrints().parallelStream().forEach(m -> Resources.blueprints().add(m.getName(), m));
        log.log(Level.INFO, "{0} blueprints loaded from {1}", new Object[]{file.getBluePrints().size(), gameResourceFile});
        int tileCnt = 0;
        for (Tileset tileset : file.getTilesets()) {
            if (Resources.tilesets().contains(tileset.getName())) continue;
            Resources.tilesets().add(tileset.getName(), tileset);
            ++tileCnt;
        }
        log.log(Level.INFO, "{0} tilesets loaded from {1}", new Object[]{tileCnt, gameResourceFile});
        List<Spritesheet> loadedSprites = Collections.synchronizedList(new ArrayList());
        file.getSpriteSheets().parallelStream().forEach(spriteSheetInfo -> {
            Spritesheet sprite = Resources.spritesheets().load((SpritesheetResource)spriteSheetInfo);
            loadedSprites.add(sprite);
        });
        log.log(Level.INFO, "{0} spritesheets loaded from {1}", new Object[]{loadedSprites.size(), gameResourceFile});
        List loadedSounds = Collections.synchronizedList(new ArrayList());
        file.getSounds().parallelStream().forEach(soundResource -> {
            Sound sound = Resources.sounds().load((SoundResource)soundResource);
            loadedSounds.add(sound);
        });
        log.log(Level.INFO, "{0} sounds loaded from {1}", new Object[]{loadedSounds.size(), gameResourceFile});
        int spriteload = 0;
        for (Spritesheet s : loadedSprites) {
            for (int i = 0; i < s.getRows() * s.getColumns(); ++i) {
                BufferedImage sprite = s.getSprite(i);
                if (sprite == null) continue;
                ++spriteload;
            }
        }
        log.log(Level.INFO, "{0} sprites loaded to memory", new Object[]{spriteload});
        for (EmitterData emitter : file.getEmitters()) {
            EmitterLoader.load(emitter);
        }
        double loadTime = TimeUtilities.nanoToMs(System.nanoTime() - loadStart);
        log.log(Level.INFO, "loading game resources from {0} took {1} ms", new Object[]{gameResourceFile, loadTime});
    }

    public static InputStream get(String file) {
        return Resources.get(Resources.getLocation(file));
    }

    public static InputStream get(URL file) {
        InputStream stream = Resources.getResource(file);
        if (stream == null) {
            return null;
        }
        return stream.markSupported() ? stream : new BufferedInputStream(stream);
    }

    public static String read(String file) {
        return Resources.read(file, StandardCharsets.UTF_8);
    }

    public static String read(String file, Charset charset) {
        URL location = Resources.getLocation(file);
        if (location == null) {
            return null;
        }
        return Resources.read(location, charset);
    }

    public static String read(URL file) {
        return Resources.read(file, StandardCharsets.UTF_8);
    }

    public static String read(URL file, Charset charset) {
        Scanner scanner = new Scanner(file.openStream(), charset.toString());
        try {
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : null;
            scanner.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage());
                return null;
            }
        }
    }

    public static void clearAll() {
        Resources.fonts().clear();
        Resources.sounds().clear();
        Resources.maps().clear();
        Resources.tilesets().clear();
        Resources.images().clear();
        Resources.spritesheets().clear();
    }

    public static URL getLocation(String name) {
        URL fromClass = ClassLoader.getSystemResource(name);
        if (fromClass != null) {
            return fromClass;
        }
        try {
            return new URL(name);
        }
        catch (MalformedURLException e) {
            try {
                return new File(name).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    private static InputStream getResource(URL file) {
        try {
            return file.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }
}

