/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.GuiComponent;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class Slider
extends GuiComponent {
    private final List<Consumer<Float>> changeConsumer = new CopyOnWriteArrayList<Consumer<Float>>();
    private ImageComponent button1;
    private ImageComponent button2;
    private ImageComponent sliderComponent;
    private Spritesheet buttonSprite;
    private Spritesheet sliderSprite;
    private float currentValue;
    private boolean isDragging;
    private boolean showTicks;
    private float minValue;
    private float maxValue;
    private float stepSize;
    private float tickSize;

    protected Slider(double x, double y, double width, double height, float minValue, float maxValue, float stepSize) {
        super(x, y, width, height);
        this.setMinValue(minValue);
        this.setCurrentValue(this.getMinValue());
        this.setMaxValue(maxValue);
        this.setStepSize(stepSize);
        this.setShowTicks(true);
        this.setTickSize(0.7f);
        this.getSliderComponent().getAppearance().setTransparentBackground(false);
        this.getSliderComponent().getAppearanceHovered().setTransparentBackground(false);
        this.onChange(e -> this.getSliderComponent().setLocation(this.getRelativeSliderLocation()));
        this.onClicked(e -> {
            this.inferValueFromMouseLocation();
            this.getSliderComponent().setLocation(this.getRelativeSliderLocation());
        });
        this.onMouseDragged(e -> {
            this.inferValueFromMouseLocation();
            this.getSliderComponent().setLocation(this.getRelativeSliderLocation());
        });
    }

    public ImageComponent getButton1() {
        return this.button1;
    }

    protected void setButton1(ImageComponent button1) {
        this.button1 = button1;
        this.button1.onClicked(e -> {
            this.setCurrentValue(this.getCurrentValue() - this.getStepSize());
            this.getChangeConsumer().forEach(consumer -> consumer.accept(Float.valueOf(this.getCurrentValue())));
        });
        this.getComponents().add(this.getButton1());
    }

    public ImageComponent getButton2() {
        return this.button2;
    }

    protected void setButton2(ImageComponent button2) {
        this.button2 = button2;
        this.button2.onClicked(e -> {
            this.setCurrentValue(this.getCurrentValue() + this.getStepSize());
            this.getChangeConsumer().forEach(consumer -> consumer.accept(Float.valueOf(this.getCurrentValue())));
        });
        this.getComponents().add(this.getButton2());
    }

    public Spritesheet getButtonSpritesheet() {
        return this.buttonSprite;
    }

    public void setButtonSpritesheet(Spritesheet buttonSprite) {
        this.buttonSprite = buttonSprite;
    }

    public List<Consumer<Float>> getChangeConsumer() {
        return this.changeConsumer;
    }

    public float getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(float newValue) {
        this.currentValue = Math.clamp(newValue, this.getMinValue(), this.getMaxValue());
        this.getChangeConsumer().forEach(consumer -> consumer.accept(Float.valueOf(this.getCurrentValue())));
    }

    public float getTickSize() {
        return this.tickSize;
    }

    public void setTickSize(float tickSize) {
        this.tickSize = tickSize;
    }

    public int getSteps() {
        return (int)((this.getMaxValue() - this.getMinValue()) / this.getStepSize()) + 1;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
        this.updateSliderDimensions();
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMinValue(float minValue) {
        this.minValue = minValue;
        this.updateSliderDimensions();
    }

    public abstract Point2D getRelativeSliderLocation();

    protected abstract float getRelativeMouseValue();

    public ImageComponent getSliderComponent() {
        return this.sliderComponent;
    }

    protected void setSliderComponent(ImageComponent slider) {
        this.sliderComponent = slider;
        this.getComponents().add(this.getSliderComponent());
    }

    protected abstract void updateSliderDimensions();

    @Override
    public void render(Graphics2D g) {
        g.setColor(this.getAppearance().getBackgroundColor2());
        this.renderBar(g);
        if (this.isShowingTicks()) {
            this.renderTicks(g);
        }
        super.render(g);
    }

    protected abstract void renderBar(Graphics2D var1);

    protected abstract void renderTicks(Graphics2D var1);

    public Spritesheet getSliderSpritesheet() {
        return this.sliderSprite;
    }

    public void setSliderSpritesheet(Spritesheet sliderSprite) {
        this.sliderSprite = sliderSprite;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float stepSize) {
        this.stepSize = stepSize;
        this.updateSliderDimensions();
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public boolean isShowingTicks() {
        return this.showTicks;
    }

    public void setShowTicks(boolean showTicks) {
        this.showTicks = showTicks;
    }

    public void onChange(Consumer<Float> c) {
        this.getChangeConsumer().add(c);
    }

    protected void inferValueFromMouseLocation() {
        float frac = (this.getMinValue() + this.getRelativeMouseValue() * (float)this.getSteps()) / (float)this.getSteps();
        int currentStep = (int)(frac * (float)this.getSteps());
        this.setCurrentValue((float)currentStep * this.getStepSize());
    }

    @Override
    public void prepare() {
        super.prepare();
        this.getSliderComponent().setLocation(this.getRelativeSliderLocation());
    }
}

