/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.resources.ImageFormat;
import de.gurkenlabs.litiengine.resources.Resources;
import de.gurkenlabs.litiengine.util.AlphanumComparator;
import de.gurkenlabs.litiengine.util.Imaging;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.Optional;
import java.util.logging.Logger;

public final class Spritesheet
implements Comparable<Spritesheet> {
    private static final Logger log = Logger.getLogger(Spritesheet.class.getName());
    private final BufferedImage image;
    private final String name;
    private final ImageFormat imageFormat;
    private BufferedImage[] sprites;
    private boolean[] emptySprites;
    private int columns;
    private int rows;
    private int spriteHeight;
    private int spriteWidth;

    public Spritesheet(BufferedImage image, String path, int spriteWidth, int spriteHeight) {
        Spritesheet.checkImage(image, path);
        this.image = image;
        this.name = FileUtilities.getFileName(path);
        this.checkHeight(spriteHeight);
        this.checkWidth(spriteWidth);
        this.spriteWidth = spriteWidth;
        this.spriteHeight = spriteHeight;
        this.imageFormat = ImageFormat.get(FileUtilities.getExtension(path));
        this.updateRowsAndCols();
        this.emptySprites = new boolean[this.getTotalNumberOfSprites()];
        this.sprites = new BufferedImage[this.getTotalNumberOfSprites()];
        Resources.spritesheets().add(this.name, this);
        Resources.images().addClearedListener(() -> {
            this.emptySprites = new boolean[this.getTotalNumberOfSprites()];
            this.sprites = new BufferedImage[this.getTotalNumberOfSprites()];
        });
    }

    @Override
    public int compareTo(Spritesheet obj) {
        return AlphanumComparator.compareTo(this.getName(), obj.getName());
    }

    public int getColumns() {
        return this.columns;
    }

    public BufferedImage getPreview(int dimension) {
        BufferedImage scaled;
        BufferedImage img = this.getSprite(0);
        String cacheKey = "iconx" + dimension + this.getName();
        Optional opt = Resources.images().tryGet(cacheKey);
        if (opt.isPresent()) {
            scaled = (BufferedImage)opt.get();
        } else {
            scaled = Imaging.scale(img, dimension, dimension, true);
            if (scaled == null) {
                scaled = Imaging.getCompatibleImage(dimension, dimension);
            }
            Resources.images().add(cacheKey, scaled);
        }
        return scaled;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public ImageFormat getImageFormat() {
        return this.imageFormat;
    }

    public String getName() {
        return this.name;
    }

    public int getRows() {
        return this.rows;
    }

    public BufferedImage getRandomSprite() {
        return Game.random().choose(this.sprites);
    }

    public BufferedImage getSprite(int index) {
        return this.getSprite(index, 0, 0);
    }

    public BufferedImage getSprite(int index, int margin, int spacing) {
        if (index < 0 || index >= this.sprites.length || this.emptySprites[index]) {
            return null;
        }
        if (this.sprites[index] != null) {
            return this.sprites[index];
        }
        if (this.getImage() == null) {
            log.warning("no image defined for sprite '" + this.getName() + "'");
            return null;
        }
        Point position = this.getPosition(index, margin, spacing);
        try {
            BufferedImage sprite = this.getImage().getSubimage(position.x, position.y, this.spriteWidth, this.spriteHeight);
            if (Imaging.isEmpty(sprite)) {
                this.emptySprites[index] = true;
                return null;
            }
            this.sprites[index] = sprite;
            return sprite;
        }
        catch (RasterFormatException rfe) {
            log.warning("could not read sprite of size [" + this.spriteWidth + "x" + this.spriteHeight + " at position [" + position.x + "," + position.y + "] from sprite'" + this.getName() + "'");
            return null;
        }
    }

    public int getSpriteHeight() {
        return this.spriteHeight;
    }

    public int getSpriteWidth() {
        return this.spriteWidth;
    }

    public int getTotalNumberOfSprites() {
        return this.getRows() * this.getColumns();
    }

    public boolean isLoaded() {
        return Resources.spritesheets().contains(this.getName()) && Resources.spritesheets().get(this.getName()).equals(this);
    }

    public void setSpriteHeight(int spriteHeight) {
        this.checkHeight(spriteHeight);
        this.spriteHeight = spriteHeight;
        this.updateRowsAndCols();
    }

    public void setSpriteWidth(int spriteWidth) {
        this.checkWidth(spriteWidth);
        this.spriteWidth = spriteWidth;
        this.updateRowsAndCols();
    }

    private void checkWidth(int value) {
        Spritesheet.checkDimension(value, this.getImage().getWidth(), this.getName(), "width");
    }

    private void checkHeight(int value) {
        Spritesheet.checkDimension(value, this.getImage().getHeight(), this.getName(), "height");
    }

    private static void checkDimension(int value, int imageValue, String imageName, String dimension) {
        if (value <= 0) {
            throw new IllegalArgumentException("Invalid sprite dimensions (" + imageName + ")! Sprite " + dimension + " must to be greater than 0.");
        }
        if (value > imageValue) {
            throw new IllegalArgumentException("Invalid sprite dimensions (" + imageName + ")! Sprite " + dimension + "(" + value + ") cannot be greater than the image " + dimension + "(" + imageValue + ").");
        }
    }

    private static void checkImage(BufferedImage image, String name) {
        if (image == null) {
            throw new IllegalArgumentException("The image for the spritesheet '" + name + "' is null!");
        }
        if (image.getWidth() <= 0 || image.getHeight() <= 0) {
            String error = String.format("Invalid image dimensions for spritesheet %s! Width and height must be greater than 0 (actual dimensions: %dx%d).", name, image.getWidth(), image.getHeight());
            throw new IllegalArgumentException(error);
        }
    }

    private Point getPosition(int index, int margin, int spacing) {
        int row = index / this.getColumns();
        int column = index % this.getColumns();
        return new Point(margin + column * (this.getSpriteWidth() + spacing), margin + row * (this.getSpriteHeight() + spacing));
    }

    private void updateRowsAndCols() {
        BufferedImage sprite = this.getImage();
        this.columns = sprite.getWidth() / this.spriteWidth;
        this.rows = sprite.getHeight() / this.spriteHeight;
    }
}

