/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.entities.LightSource;
import de.gurkenlabs.litiengine.entities.StaticShadow;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.graphics.ColorLayer;
import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import de.gurkenlabs.litiengine.util.geom.Vector2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AmbientLight
extends ColorLayer {
    public static final Color DEFAULT_COLOR = new Color(0, 0, 0, 0);

    public AmbientLight(Environment environment, Color ambientColor) {
        super(environment, ambientColor);
    }

    @Override
    protected void renderSection(Graphics2D g, Rectangle2D section) {
        this.renderAmbient(g, section);
        g.setComposite(AlphaComposite.getInstance(8, 1.0f));
        this.getEnvironment().getLightSources().forEach(light -> this.carveOutLight(g, (LightSource)light, section));
        this.getEnvironment().getLightSources().forEach(light -> this.renderActualLight(g, (LightSource)light, section));
    }

    @Override
    protected void clearSection(Graphics2D g, Rectangle2D section) {
        g.setColor(new Color(0, 0, 0, 0));
        g.clearRect((int)section.getX(), (int)section.getY(), (int)section.getWidth(), (int)section.getHeight());
    }

    private void carveOutLight(Graphics2D g, LightSource light, Rectangle2D section) {
        if (!light.getBoundingBox().intersects(section) || !light.isActive()) {
            return;
        }
        this.renderLightSource(g, light, section);
    }

    private void renderActualLight(Graphics2D g, LightSource light, Rectangle2D section) {
        if (!light.getBoundingBox().intersects(section) || !light.isActive() || light.getIntensity() <= 0) {
            return;
        }
        float intensity = Math.clamp((float)light.getIntensity() / 255.0f, 0.0f, 1.0f);
        g.setComposite(AlphaComposite.getInstance(3, intensity));
        this.renderLightSource(g, light, section);
    }

    private void renderAmbient(Graphics2D g, Rectangle2D section) {
        g.setColor(this.getColor());
        g.setComposite(AlphaComposite.getInstance(5, 1.0f));
        ShapeRenderer.render(g, section);
    }

    private void subtractShadow(Area lightArea, StaticShadow shadow) {
        Line2D[] bounds;
        if (!lightArea.intersects(shadow.getBoundingBox())) {
            return;
        }
        double mapWidth = this.getEnvironment().getMap().getSizeInPixels().width;
        double mapHeight = this.getEnvironment().getMap().getSizeInPixels().height;
        double longerDimension = Math.max(mapWidth, mapHeight);
        Point2D.Double center = new Point2D.Double(lightArea.getBounds2D().getCenterX(), lightArea.getBounds2D().getCenterY());
        Area boxInLight = new Area(shadow.getBoundingBox());
        for (Line2D line : bounds = GeometricUtilities.getLines(shadow.getBoundingBox())) {
            Vector2D lineVector = new Vector2D(line.getP1(), line.getP2());
            Vector2D lightVector = new Vector2D(center, line.getP1());
            if (((Point2D)center).getY() < line.getY1() && ((Point2D)center).getY() < line.getY2() && shadow.getBoundingBox().contains(center) || lineVector.normalVector().dotProduct(lightVector) >= 0.0) continue;
            Path2D.Double shadowParallelogram = new Path2D.Double();
            Point2D shadowPoint1 = GeometricUtilities.project((Point2D)center, line.getP1(), longerDimension);
            Point2D shadowPoint2 = GeometricUtilities.project((Point2D)center, line.getP2(), longerDimension);
            ((Path2D)shadowParallelogram).moveTo(line.getP1().getX(), line.getP1().getY());
            ((Path2D)shadowParallelogram).lineTo(shadowPoint1.getX(), shadowPoint1.getY());
            ((Path2D)shadowParallelogram).lineTo(shadowPoint2.getX(), shadowPoint2.getY());
            ((Path2D)shadowParallelogram).lineTo(line.getP2().getX(), line.getP2().getY());
            shadowParallelogram.closePath();
            Area shadowArea = new Area(shadowParallelogram);
            if (((Point2D)center).getY() < shadow.getBoundingBox().getMaxY() && !shadow.getBoundingBox().contains(center)) {
                shadowArea.add(boxInLight);
            }
            shadowArea.intersect(lightArea);
            lightArea.subtract(shadowArea);
        }
    }

    private void renderLightSource(Graphics2D g, LightSource light, Rectangle2D section) {
        Area lightArea = new Area(light.getLightShape());
        if (light.getLightShapeType() == LightSource.Type.RECTANGLE) {
            g.setColor(light.getColor());
            ShapeRenderer.render(g, new Rectangle2D.Double(light.getBoundingBox().getX() - section.getX(), light.getBoundingBox().getY() - section.getY(), light.getBoundingBox().getWidth(), light.getBoundingBox().getHeight()));
            return;
        }
        this.getEnvironment().getStaticShadows().forEach(shadow -> this.subtractShadow(lightArea, (StaticShadow)shadow));
        Paint oldPaint = g.getPaint();
        g.setPaint(light.getGradientPaint());
        ShapeRenderer.render(g, lightArea);
        g.setPaint(oldPaint);
    }
}

