/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.environment.tilemap.ITilesetEntry;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapImage;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Tileset;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TmxException;
import de.gurkenlabs.litiengine.resources.Resources;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.image.BufferedImage;
import java.net.URL;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class TilesetEntry
extends CustomPropertyProvider
implements ITilesetEntry {
    @XmlTransient
    private Tileset tileset;
    @XmlAttribute
    private Integer id;
    @XmlAttribute
    private String terrain;
    @XmlElement
    private TileAnimation animation;
    @XmlElement
    private MapImage image;
    @XmlAttribute
    private String type;
    @XmlElement(name="objectgroup")
    private MapObjectLayer collisionData;

    public TilesetEntry() {
    }

    public TilesetEntry(Tileset tileset, int id) {
        this.tileset = tileset;
        this.id = id;
    }

    @Override
    public int getId() {
        if (this.id == null) {
            return 0;
        }
        return this.id;
    }

    @Override
    public ITileAnimation getAnimation() {
        return this.animation;
    }

    @Override
    public BufferedImage getImage() {
        if (this.animation == null) {
            return this.getBasicImage();
        }
        return this.tileset.getTile(this.animation.getCurrentFrame().getTileId()).getBasicImage();
    }

    @Override
    public BufferedImage getBasicImage() {
        if (this.image != null) {
            return (BufferedImage)Resources.images().get(this.image.getAbsoluteSourcePath());
        }
        return this.tileset.getSpritesheet().getSprite(this.getId(), this.tileset.getMargin(), this.tileset.getSpacing());
    }

    @Override
    public ITileset getTileset() {
        return this.tileset;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public IMapObjectLayer getCollisionInfo() {
        return this.collisionData;
    }

    @Override
    void finish(URL location) throws TmxException {
        super.finish(location);
        if (this.image != null) {
            this.image.finish(location);
        }
    }

    boolean shouldBeSaved() {
        return this.terrain != null || this.image != null || this.animation != null || this.type != null;
    }

    private void afterUnmarshal(Unmarshaller u, Object parent) {
        this.tileset = (Tileset)parent;
    }
}

