/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities.behavior;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.entities.behavior.NavigationListener;
import de.gurkenlabs.litiengine.entities.behavior.Path;
import de.gurkenlabs.litiengine.entities.behavior.PathFinder;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;

public class EntityNavigator
implements IUpdateable,
IRenderable {
    private static final float DEFAULT_ACCEPTABLE_ERROR = 0.3f;
    private final List<Predicate<IMobileEntity>> cancelNavigationConditions = new CopyOnWriteArrayList<Predicate<IMobileEntity>>();
    private final List<NavigationListener> listeners = new CopyOnWriteArrayList<NavigationListener>();
    private final IMobileEntity entity;
    private final PathFinder pathFinder;
    private int currentSegment;
    private Path path;
    private float acceptableError;

    public EntityNavigator(IMobileEntity entity, PathFinder pathFinder) {
        this.entity = entity;
        this.pathFinder = pathFinder;
        this.setAcceptableError(0.3f);
        Game.loop().attach(this);
    }

    public EntityNavigator(IMobileEntity entity) {
        this(entity, null);
    }

    public void addNavigationListener(NavigationListener listener) {
        this.listeners.add(listener);
    }

    public void removeNavigationListener(NavigationListener listener) {
        this.listeners.remove(listener);
    }

    public void cancelNavigation(Predicate<IMobileEntity> predicate) {
        if (!this.cancelNavigationConditions.contains(predicate)) {
            this.cancelNavigationConditions.add(predicate);
        }
    }

    public IMobileEntity getEntity() {
        return this.entity;
    }

    public Path getPath() {
        return this.path;
    }

    public PathFinder getPathFinder() {
        return this.pathFinder;
    }

    public float getAcceptableError() {
        return this.acceptableError;
    }

    public boolean isNavigating() {
        return this.getPath() != null;
    }

    public boolean navigate(Path2D path) {
        this.path = new Path(path);
        return this.getPath() != null;
    }

    public boolean navigate(Point2D target) {
        if (this.getPathFinder() != null) {
            this.path = this.getPathFinder().findPath(this.getEntity(), target);
        }
        return this.getPath() != null;
    }

    @Override
    public void render(Graphics2D g) {
        if (this.getPath() == null) {
            return;
        }
        g.setColor(Color.MAGENTA);
        Game.graphics().renderOutline(g, this.getPath().getPath());
    }

    public void rotateTowards(Point2D target) {
        double angle = GeometricUtilities.calcRotationAngleInDegrees(this.getEntity().getCollisionBox().getCenterX(), this.getEntity().getCollisionBox().getCenterY(), target.getX(), target.getY());
        this.getEntity().setAngle((float)angle);
    }

    public void setAcceptableError(float acceptableError) {
        this.acceptableError = acceptableError;
    }

    public void stop() {
        this.currentSegment = 0;
        this.path = null;
        for (NavigationListener listener : this.listeners) {
            listener.stopped();
        }
    }

    @Override
    public void update() {
        if (!this.isNavigating()) {
            return;
        }
        if (this.getPath() == null) {
            return;
        }
        for (Predicate<IMobileEntity> pred : this.cancelNavigationConditions) {
            if (!pred.test(this.getEntity())) continue;
            this.stop();
            return;
        }
        PathIterator pi = this.getPath().getPath().getPathIterator(null);
        if (pi.isDone()) {
            this.stop();
            return;
        }
        double[] startCoordinates = new double[22];
        double[] coordinates = new double[22];
        for (int i = 0; i <= this.currentSegment; ++i) {
            if (pi.isDone()) {
                this.stop();
                return;
            }
            pi.currentSegment(startCoordinates);
            pi.next();
        }
        if (pi.isDone()) {
            this.stop();
            return;
        }
        pi.currentSegment(coordinates);
        double distance = GeometricUtilities.distance(this.getEntity().getCollisionBox().getCenterX(), this.getEntity().getCollisionBox().getCenterY(), coordinates[0], coordinates[1]);
        if (distance < (double)this.getAcceptableError()) {
            ++this.currentSegment;
            return;
        }
        double angle = GeometricUtilities.calcRotationAngleInDegrees(this.getEntity().getCollisionBox().getCenterX(), this.getEntity().getCollisionBox().getCenterY(), coordinates[0], coordinates[1]);
        float pixelsPerTick = this.getEntity().getTickVelocity();
        Game.physics().move(this.getEntity(), (float)angle, (double)((float)(distance < (double)pixelsPerTick ? distance : (double)pixelsPerTick)));
    }
}

