/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.Entity;
import de.gurkenlabs.litiengine.entities.EntityPivot;
import de.gurkenlabs.litiengine.entities.EntityPivotType;
import de.gurkenlabs.litiengine.entities.EntitySpawnedEvent;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.Environment;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.environment.tilemap.TmxType;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.EventListener;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@TmxType(value=MapObjectType.SPAWNPOINT)
public class Spawnpoint
extends Entity {
    private final Collection<EntitySpawnedListener> spawnedListeners = ConcurrentHashMap.newKeySet();
    @TmxProperty(name="spawnDirection")
    private Direction direction;
    @TmxProperty(name="spawnInfo")
    private String spawnInfo;
    @TmxProperty(name="spawnPivot")
    private EntityPivotType spawnPivotType;
    @TmxProperty(name="spawnPivotOffsetX")
    private double spawnOffsetX;
    @TmxProperty(name="spawnPivotOffsetY")
    private double spawnOffsetY;

    public Spawnpoint() {
        this.setSize(1.0, 1.0);
    }

    public Spawnpoint(double x, double y) {
        this(0, x, y);
    }

    public Spawnpoint(Point2D location) {
        this(0, location);
    }

    public Spawnpoint(double x, double y, Direction direction) {
        this(0, x, y, direction);
    }

    public Spawnpoint(Point2D location, Direction direction) {
        this(0, location, direction);
    }

    public Spawnpoint(int mapId, double x, double y) {
        this(mapId, new Point2D.Double(x, y));
    }

    public Spawnpoint(int mapId, Point2D location) {
        super(mapId);
        this.setSize(1.0, 1.0);
        this.setLocation(location);
    }

    public Spawnpoint(int mapId, double x, double y, Direction direction) {
        this(mapId, new Point2D.Double(x, y), direction);
    }

    public Spawnpoint(int mapId, Point2D location, Direction direction) {
        this(mapId, location);
        this.setDirection(direction);
    }

    public Spawnpoint(Direction direction) {
        this.setDirection(direction);
    }

    public Spawnpoint(Direction direction, String spawnType) {
        this(direction);
        this.setSpawnInfo(spawnType);
    }

    public void onSpawned(EntitySpawnedListener listener) {
        this.spawnedListeners.add(listener);
    }

    public void removeSpawnedListener(EntitySpawnedListener listener) {
        this.spawnedListeners.remove(listener);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public String getSpawnInfo() {
        return this.spawnInfo;
    }

    public void setSpawnInfo(String spawnInfo) {
        this.spawnInfo = spawnInfo;
    }

    public EntityPivotType getSpawnPivotType() {
        return this.spawnPivotType;
    }

    public void setSpawnPivotType(EntityPivotType spawnPivotType) {
        this.spawnPivotType = spawnPivotType;
    }

    public double getSpawnOffsetX() {
        return this.spawnOffsetX;
    }

    public void setSpawnOffsetX(double spawnOffsetX) {
        this.spawnOffsetX = spawnOffsetX;
    }

    public double getSpawnOffsetY() {
        return this.spawnOffsetY;
    }

    public void setSpawnOffsetY(double spawnOffsetY) {
        this.spawnOffsetY = spawnOffsetY;
    }

    public boolean spawn(IEntity entity) {
        Environment env = Optional.ofNullable(this.getEnvironment()).orElse(Game.world().environment());
        if (env == null) {
            return false;
        }
        entity.setLocation(this.getEntityLocationByPivot(entity));
        if (this.getDirection() != null && this.getDirection() != Direction.UNDEFINED) {
            entity.setAngle(this.getDirection().toAngle());
        }
        if (env.get(entity.getMapId()) == null) {
            env.add(entity);
        }
        EntitySpawnedEvent event = new EntitySpawnedEvent(this, entity);
        for (EntitySpawnedListener listener : this.spawnedListeners) {
            listener.spawned(event);
        }
        return true;
    }

    private Point2D getEntityLocationByPivot(IEntity entity) {
        if (this.getSpawnPivotType() == null || this.getSpawnPivotType() == EntityPivotType.LOCATION) {
            return this.getLocation();
        }
        EntityPivot pivot = new EntityPivot(this, this.getSpawnPivotType(), -entity.getWidth() / 2.0, -entity.getHeight() / 2.0);
        return pivot.getPoint();
    }

    @FunctionalInterface
    public static interface EntitySpawnedListener
    extends EventListener {
        public void spawned(EntitySpawnedEvent var1);
    }
}

