/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.abilities.Ability;
import de.gurkenlabs.litiengine.abilities.effects.Effect;
import de.gurkenlabs.litiengine.attributes.AttributeModifier;
import de.gurkenlabs.litiengine.attributes.Modification;
import de.gurkenlabs.litiengine.attributes.RangeAttribute;
import de.gurkenlabs.litiengine.entities.CollisionEntity;
import de.gurkenlabs.litiengine.entities.CollisionInfo;
import de.gurkenlabs.litiengine.entities.CombatEntityDeathListener;
import de.gurkenlabs.litiengine.entities.CombatEntityHitListener;
import de.gurkenlabs.litiengine.entities.CombatEntityListener;
import de.gurkenlabs.litiengine.entities.CombatEntityResurrectListener;
import de.gurkenlabs.litiengine.entities.CombatInfo;
import de.gurkenlabs.litiengine.entities.EntityHitEvent;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.tweening.TweenType;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@CombatInfo
@CollisionInfo(collision=true)
public class CombatEntity
extends CollisionEntity
implements ICombatEntity {
    public static final int DEFAULT_HITPOINTS = 100;
    private final Collection<CombatEntityListener> listeners = ConcurrentHashMap.newKeySet();
    private final Collection<CombatEntityDeathListener> deathListeners = ConcurrentHashMap.newKeySet();
    private final Collection<CombatEntityResurrectListener> resurrectListeners = ConcurrentHashMap.newKeySet();
    private final Collection<CombatEntityHitListener> hitListeners = ConcurrentHashMap.newKeySet();
    private final List<Effect> appliedEffects = new CopyOnWriteArrayList<Effect>();
    private final RangeAttribute<Integer> hitPoints;
    @TmxProperty(name="indestructible")
    private boolean isIndestructible;
    @TmxProperty(name="team")
    private int team;
    @TmxProperty(name="hitpoints")
    private int initialHitpoints;
    private ICombatEntity target;
    private long lastHit;

    public CombatEntity() {
        CombatInfo info = this.getClass().getAnnotation(CombatInfo.class);
        this.initialHitpoints = info.hitpoints();
        this.setTeam(info.team());
        this.setIndestructible(info.isIndestructible());
        this.hitPoints = new RangeAttribute<Integer>(this.initialHitpoints, 0, this.initialHitpoints);
    }

    @Override
    public void addCombatEntityListener(CombatEntityListener listener) {
        this.listeners.add(listener);
        this.hitListeners.add(listener);
        this.deathListeners.add(listener);
    }

    @Override
    public void removeCombatEntityListener(CombatEntityListener listener) {
        this.listeners.remove(listener);
        this.hitListeners.remove(listener);
        this.deathListeners.remove(listener);
    }

    @Override
    public void onHit(CombatEntityHitListener listener) {
        this.hitListeners.add(listener);
    }

    @Override
    public void onDeath(CombatEntityDeathListener listener) {
        this.deathListeners.add(listener);
    }

    @Override
    public void onResurrect(CombatEntityResurrectListener listener) {
        this.resurrectListeners.add(listener);
    }

    @Override
    public void removeListener(CombatEntityHitListener listener) {
        this.hitListeners.remove(listener);
    }

    @Override
    public void removeListener(CombatEntityDeathListener listener) {
        this.deathListeners.remove(listener);
    }

    @Override
    public void removeListener(CombatEntityResurrectListener listener) {
        this.resurrectListeners.remove(listener);
    }

    @Override
    public void die() {
        if (this.isDead()) {
            return;
        }
        this.getHitPoints().modifyBaseValue(new AttributeModifier(Modification.SET, 0.0));
        this.fireDeathEvent(null);
    }

    @Override
    public List<Effect> getAppliedEffects() {
        return this.appliedEffects;
    }

    @Override
    public RangeAttribute<Integer> getHitPoints() {
        return this.hitPoints;
    }

    @Override
    public Shape getHitBox() {
        return new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    @Override
    public ICombatEntity getTarget() {
        return this.target;
    }

    @Override
    public int getTeam() {
        return this.team;
    }

    @Override
    public float[] getTweenValues(TweenType tweenType) {
        if (tweenType == TweenType.HITPOINTS) {
            return new float[]{this.getHitPoints().get().intValue()};
        }
        return super.getTweenValues(tweenType);
    }

    @Override
    public void setTweenValues(TweenType tweenType, float[] newValues) {
        if (tweenType == TweenType.HITPOINTS) {
            this.getHitPoints().setBaseValue(Math.round(newValues[0]));
        } else {
            super.setTweenValues(tweenType, newValues);
        }
    }

    @Override
    public void hit(int damage) {
        this.hit(damage, null);
    }

    @Override
    public void hit(int damage, Ability ability) {
        if (this.isDead()) {
            return;
        }
        if (!this.isIndestructible()) {
            this.getHitPoints().modifyBaseValue(new AttributeModifier(Modification.SUBTRACT, damage));
        }
        EntityHitEvent event = new EntityHitEvent(this, ability, damage, this.isDead());
        for (CombatEntityListener combatEntityListener : this.listeners) {
            combatEntityListener.hit(event);
        }
        for (CombatEntityHitListener combatEntityHitListener : this.hitListeners) {
            combatEntityHitListener.hit(event);
        }
        if (this.isDead()) {
            this.fireDeathEvent(event);
        }
        this.lastHit = Game.time().now();
    }

    protected void fireDeathEvent(EntityHitEvent entityHitEvent) {
        this.setCollision(false);
        for (CombatEntityListener combatEntityListener : this.listeners) {
            combatEntityListener.death(this, entityHitEvent);
        }
        for (CombatEntityDeathListener combatEntityDeathListener : this.deathListeners) {
            combatEntityDeathListener.death(this, entityHitEvent);
        }
    }

    @Override
    public boolean isDead() {
        return !this.isIndestructible() && this.getHitPoints().get() <= 0;
    }

    @Override
    public boolean isFriendly(ICombatEntity entity) {
        return entity != null && this.getTeam() == entity.getTeam();
    }

    @Override
    public boolean isIndestructible() {
        return this.isIndestructible;
    }

    @Override
    public boolean isNeutral() {
        return this.getTeam() == 0;
    }

    @Override
    public void resurrect() {
        if (!this.isDead()) {
            return;
        }
        this.getHitPoints().modifyBaseValue(new AttributeModifier(Modification.SET, this.getHitPoints().getMax().intValue()));
        for (CombatEntityListener combatEntityListener : this.listeners) {
            combatEntityListener.resurrect(this);
        }
        for (CombatEntityResurrectListener combatEntityResurrectListener : this.resurrectListeners) {
            combatEntityResurrectListener.resurrect(this);
        }
        this.setCollision(true);
    }

    @Override
    public void setIndestructible(boolean indestructible) {
        this.isIndestructible = indestructible;
    }

    @Override
    public void setTarget(ICombatEntity target) {
        this.target = target;
    }

    @Override
    public void setTeam(int team) {
        this.team = team;
    }

    @Override
    public boolean wasHit(int timeSpan) {
        return Game.time().since(this.lastHit) < (long)timeSpan;
    }
}

