/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.entities.CollisionInfo;
import de.gurkenlabs.litiengine.entities.CollisionListener;
import de.gurkenlabs.litiengine.entities.Entity;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.physics.Collision;
import de.gurkenlabs.litiengine.physics.CollisionEvent;
import de.gurkenlabs.litiengine.tweening.TweenType;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@CollisionInfo(collision=true)
public abstract class CollisionEntity
extends Entity
implements ICollisionEntity {
    private static final Logger log = Logger.getLogger(CollisionEntity.class.getName());
    private static final double HEIGHT_FACTOR = 0.4;
    private static final double WIDTH_FACTOR = 0.4;
    private final Collection<CollisionListener> collisionListener = ConcurrentHashMap.newKeySet();
    @TmxProperty(name="collisionAlign")
    private Align align;
    @TmxProperty(name="collision")
    private boolean collision;
    @TmxProperty(name="collisionboxHeight")
    private double collisionBoxHeight;
    @TmxProperty(name="collisionboxWidth")
    private double collisionBoxWidth;
    @TmxProperty(name="collisionValign")
    private Valign valign;
    @TmxProperty(name="collisionType")
    private Collision collisionType;
    private Rectangle2D collisionBox;

    protected CollisionEntity() {
        CollisionInfo info = this.getClass().getAnnotation(CollisionInfo.class);
        this.collisionBoxWidth = info.collisionBoxWidth();
        this.collisionBoxHeight = info.collisionBoxHeight();
        this.collision = info.collision();
        this.valign = info.valign();
        this.align = info.align();
        this.collisionType = info.collisionType();
        this.refreshCollisionBox();
    }

    public static Rectangle2D getCollisionBox(Point2D location, double entityWidth, double entityHeight, double collisionBoxWidth, double collisionBoxHeight, Align align, Valign valign) {
        double x = location.getX() + align.getLocation(entityWidth, collisionBoxWidth);
        double y = location.getY() + valign.getLocation(entityHeight, collisionBoxHeight);
        return new Rectangle2D.Double(x, y, collisionBoxWidth, collisionBoxHeight);
    }

    @Override
    public boolean canCollideWith(ICollisionEntity otherEntity) {
        return true;
    }

    @Override
    public Align getCollisionBoxAlign() {
        return this.align;
    }

    @Override
    public Rectangle2D getCollisionBox() {
        return this.collisionBox;
    }

    @Override
    public Rectangle2D getCollisionBox(Point2D location) {
        double newCollisionBoxWidth = this.getCollisionBoxWidth() != -1.0 ? this.getCollisionBoxWidth() : (double)Math.round(this.getWidth() * 0.4);
        double newCollisionBoxHeight = this.getCollisionBoxHeight() != -1.0 ? this.getCollisionBoxHeight() : (double)Math.round(this.getHeight() * 0.4);
        return CollisionEntity.getCollisionBox(location, this.getWidth(), this.getHeight(), newCollisionBoxWidth, newCollisionBoxHeight, this.getCollisionBoxAlign(), this.getCollisionBoxValign());
    }

    @Override
    public double getCollisionBoxHeight() {
        return this.collisionBoxHeight;
    }

    @Override
    public double getCollisionBoxWidth() {
        return this.collisionBoxWidth;
    }

    @Override
    public Point2D getCollisionBoxCenter() {
        return new Point2D.Double(this.getCollisionBox().getCenterX(), this.getCollisionBox().getCenterY());
    }

    @Override
    public Valign getCollisionBoxValign() {
        return this.valign;
    }

    @Override
    public Collision getCollisionType() {
        return this.collisionType;
    }

    @Override
    public float[] getTweenValues(TweenType tweenType) {
        switch (tweenType) {
            case COLLISION_WIDTH: {
                return new float[]{(float)this.getCollisionBoxWidth()};
            }
            case COLLISION_HEIGHT: {
                return new float[]{(float)this.getCollisionBoxHeight()};
            }
            case COLLISION_BOTH: {
                return new float[]{(float)this.getCollisionBoxWidth(), (float)this.getCollisionBoxHeight()};
            }
        }
        return super.getTweenValues(tweenType);
    }

    @Override
    public void setTweenValues(TweenType tweenType, float[] newValues) {
        switch (tweenType) {
            case COLLISION_WIDTH: {
                this.setCollisionBoxWidth(newValues[0]);
                break;
            }
            case COLLISION_HEIGHT: {
                this.setCollisionBoxHeight(newValues[0]);
                break;
            }
            case COLLISION_BOTH: {
                this.setCollisionBoxWidth(newValues[0]);
                this.setCollisionBoxHeight(newValues[1]);
                break;
            }
            default: {
                super.setTweenValues(tweenType, newValues);
            }
        }
    }

    @Override
    public boolean hasCollision() {
        return this.collision && this.getCollisionBoxWidth() > 0.0 && this.getCollisionBoxHeight() > 0.0;
    }

    @Override
    public void setCollision(boolean collision) {
        this.collision = collision;
    }

    @Override
    public void setCollisionBoxAlign(Align align) {
        this.align = align;
        this.refreshCollisionBox();
    }

    @Override
    public void setCollisionBoxHeight(double collisionBoxHeight) {
        this.collisionBoxHeight = collisionBoxHeight;
        this.refreshCollisionBox();
    }

    @Override
    public void setCollisionBoxValign(Valign valign) {
        this.valign = valign;
        this.refreshCollisionBox();
    }

    @Override
    public void setCollisionBoxWidth(double collisionBoxWidth) {
        this.collisionBoxWidth = collisionBoxWidth;
        this.refreshCollisionBox();
    }

    @Override
    public void setLocation(Point2D location) {
        super.setLocation(location);
        this.refreshCollisionBox();
    }

    @Override
    public void setSize(double width, double height) {
        super.setSize(width, height);
        this.refreshCollisionBox();
    }

    @Override
    public void setHeight(double height) {
        super.setHeight(height);
        this.refreshCollisionBox();
    }

    @Override
    public void setWidth(double width) {
        super.setWidth(width);
        this.refreshCollisionBox();
    }

    @Override
    public void setCollisionType(Collision type) {
        if (type == Collision.ANY) {
            log.log(Level.WARNING, "Collision.ANY is not allowed to be assigned to an entity. It may only be used for filtering in the PhysicsEngine.");
            return;
        }
        if (this.getEnvironment() != null && this.getEnvironment().isLoaded()) {
            Game.physics().remove(this);
            this.collisionType = type;
            Game.physics().add(this);
        } else {
            this.collisionType = type;
        }
    }

    @Override
    public void onCollision(CollisionListener listener) {
        this.collisionListener.add(listener);
    }

    @Override
    public void removeCollisionListener(CollisionListener listener) {
        this.collisionListener.remove(listener);
    }

    @Override
    public void fireCollisionEvent(CollisionEvent event) {
        for (CollisionListener listener : this.collisionListener) {
            listener.collisionResolved(event);
        }
    }

    protected void refreshCollisionBox() {
        this.collisionBox = this.getCollisionBox(this.getLocation());
    }

    private void afterTmxUnmarshal(IMapObject mapObject) {
        this.refreshCollisionBox();
    }
}

