/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.configuration;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeSet;

class CleanProperties
extends Properties {
    private static final long serialVersionUID = 7567765340218227372L;

    CleanProperties() {
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Collections.enumeration(new TreeSet<Object>(super.keySet()));
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        super.store(new StripFirstLineStream(out), null);
    }

    private static class StripFirstLineStream
    extends FilterOutputStream {
        private boolean firstlineseen = false;

        public StripFirstLineStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            if (this.firstlineseen) {
                this.out.write(b);
            } else if (b == 10) {
                this.firstlineseen = true;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            while (!this.firstlineseen) {
                if (b[off++] == 10) {
                    this.firstlineseen = true;
                }
                if (--len != 0) continue;
                return;
            }
            this.out.write(b, off, len);
        }
    }
}

