/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import jakarta.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum Valign {
    DOWN(1.0f),
    MIDDLE(0.5f),
    TOP(0.0f),
    MIDDLE_TOP(0.25f),
    MIDDLE_DOWN(0.75f);

    private final float portion;

    private Valign(float portion) {
        this.portion = portion;
    }

    public static Valign get(String valignString) {
        if (valignString == null || valignString.isEmpty()) {
            return DOWN;
        }
        try {
            return Valign.valueOf(valignString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return DOWN;
        }
    }

    public float getValue(float height) {
        return height * this.portion;
    }

    public double getValue(double height) {
        return height * (double)this.portion;
    }

    public int getValue(int height) {
        return (int)((float)height * this.portion);
    }

    public double getLocation(double height, double objectHeight) {
        return this.getLocation(height, objectHeight, false);
    }

    public double getLocation(double height, double objectHeight, boolean preventOverflow) {
        double value = this.getValue(height);
        double location = value - objectHeight / 2.0;
        if (objectHeight > height && !preventOverflow) {
            return location;
        }
        return Math.max(0.0, Math.min(height - objectHeight, location));
    }

    public float getPortion() {
        return this.portion;
    }
}

