/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.tweening;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.ILaunchable;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.tweening.Tween;
import de.gurkenlabs.litiengine.tweening.TweenFunction;
import de.gurkenlabs.litiengine.tweening.TweenType;
import de.gurkenlabs.litiengine.tweening.Tweenable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TweenEngine
implements IUpdateable,
ILaunchable {
    private final Map<Tweenable, Map<TweenType, Tween>> tweens = new ConcurrentHashMap<Tweenable, Map<TweenType, Tween>>();

    public Tween begin(Tweenable target, TweenType type, int duration) {
        Tween tween = this.getTween(target, type);
        if (tween == null) {
            tween = new Tween(target, type, duration).ease(TweenFunction.QUAD_INOUT);
            this.getTweens().get(target).put(type, tween);
        } else {
            tween.setDuration(duration);
        }
        tween.begin();
        return tween;
    }

    public Tween getTween(Tweenable target, TweenType type) {
        if (this.getTweens().get(target) == null) {
            this.getTweens().put(target, new ConcurrentHashMap());
        }
        return this.getTweens().get(target).get((Object)type);
    }

    public Map<Tweenable, Map<TweenType, Tween>> getTweens() {
        return this.tweens;
    }

    public Tween reset(Tweenable target, TweenType type) {
        Tween tween = this.getTween(target, type);
        if (tween != null) {
            tween.stop();
            tween.reset();
        }
        return tween;
    }

    public Tween resume(Tweenable target, TweenType type) {
        Tween tween = this.getTween(target, type);
        if (tween != null) {
            tween.resume();
        }
        return tween;
    }

    @Override
    public void start() {
        Game.loop().attach(this);
    }

    public void remove(Tweenable target, TweenType type) {
        Tween tween = this.getTween(target, type);
        if (tween != null) {
            this.getTweens().get(target).remove((Object)type);
        }
    }

    public void remove(Tweenable target) {
        if (this.getTweens().containsKey(target)) {
            this.getTweens().get(target).clear();
            this.getTweens().remove(target);
        }
    }

    public Tween stop(Tweenable target, TweenType type) {
        Tween tween = this.getTween(target, type);
        if (tween != null) {
            tween.stop();
        }
        return tween;
    }

    @Override
    public void terminate() {
        Game.loop().detach(this);
    }

    @Override
    public void update() {
        for (Tweenable target : this.getTweens().keySet()) {
            for (Tween tween : this.getTweens().get(target).values()) {
                if (tween.hasStopped()) continue;
                long elapsed = Game.time().since(tween.getStartTime());
                if (elapsed >= (long)tween.getDuration()) {
                    tween.stop();
                    continue;
                }
                float[] currentValues = new float[tween.getTargetValues().length];
                for (int i = 0; i < tween.getTargetValues().length; ++i) {
                    currentValues[i] = tween.getStartValues()[i] + tween.getEquation().compute((float)elapsed / (float)tween.getDuration()) * (tween.getTargetValues()[i] - tween.getStartValues()[i]);
                }
                tween.getTarget().setTweenValues(tween.getType(), currentValues);
            }
        }
    }
}

