/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.input.Gamepad;
import java.util.EventObject;
import net.java.games.input.Component;

public class GamepadEvent
extends EventObject {
    private static final long serialVersionUID = -6174813700465768116L;
    private final transient Gamepad gamepad;
    private final String component;
    private final String componentName;
    private final float value;
    private final boolean relative;
    private final boolean analog;

    GamepadEvent(Gamepad source, Component component) {
        super(source);
        this.gamepad = source;
        this.component = component.getIdentifier().getName();
        this.componentName = component.getName();
        this.value = component.getPollData();
        this.relative = component.isRelative();
        this.analog = component.isAnalog();
    }

    public float getValue() {
        return this.value;
    }

    public String getComponentId() {
        return this.component;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Gamepad getGamepad() {
        return this.gamepad;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public boolean isAnalog() {
        return this.analog;
    }
}

