/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.ITimeToLive;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.CollisionInfo;
import de.gurkenlabs.litiengine.entities.EmitterInfo;
import de.gurkenlabs.litiengine.entities.Entity;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.TmxType;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.graphics.emitters.particles.EllipseParticle;
import de.gurkenlabs.litiengine.graphics.emitters.particles.LineParticle;
import de.gurkenlabs.litiengine.graphics.emitters.particles.Particle;
import de.gurkenlabs.litiengine.graphics.emitters.particles.PolygonParticle;
import de.gurkenlabs.litiengine.graphics.emitters.particles.RectangleParticle;
import de.gurkenlabs.litiengine.graphics.emitters.particles.SpriteParticle;
import de.gurkenlabs.litiengine.graphics.emitters.particles.TextParticle;
import de.gurkenlabs.litiengine.graphics.emitters.xml.EmitterData;
import de.gurkenlabs.litiengine.graphics.emitters.xml.EmitterLoader;
import de.gurkenlabs.litiengine.graphics.emitters.xml.ParticleParameter;
import de.gurkenlabs.litiengine.resources.Resources;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@CollisionInfo(collision=false)
@EmitterInfo
@TmxType(value=MapObjectType.EMITTER)
public class Emitter
extends Entity
implements IUpdateable,
ITimeToLive,
IRenderable {
    private final Collection<EmitterFinishedListener> finishedListeners = ConcurrentHashMap.newKeySet();
    private final CopyOnWriteArrayList<Particle> particles = new CopyOnWriteArrayList();
    private final Map<RenderType, IRenderable> renderables = new ConcurrentHashMap<RenderType, IRenderable>();
    private EmitterData emitterData;
    private boolean activateOnInit;
    private boolean activated;
    private boolean paused;
    private boolean stopped;
    private long activationTick;
    private long aliveTime;
    private long lastSpawn;
    private Point2D origin;

    public Emitter() {
        for (RenderType type : RenderType.values()) {
            if (type == RenderType.NONE) continue;
            this.renderables.put(type, g -> this.renderParticles(g, type));
        }
        this.emitterData = new EmitterData();
        this.emitterData.setRequiredQuality(EmitterData.DEFAULT_REQUIRED_QUALITY);
        EmitterInfo info = this.getClass().getAnnotation(EmitterInfo.class);
        if (info != null) {
            this.emitterData.setParticleType(info.particleType());
            this.emitterData.setRequiredQuality(info.requiredQuality());
            this.emitterData.setMaxParticles(info.maxParticles());
            this.emitterData.setSpawnAmount(info.spawnAmount());
            this.emitterData.setSpawnRate(info.spawnRate());
            this.emitterData.setEmitterDuration(info.duration());
            this.emitterData.setParticleTTL(new ParticleParameter(info.particleMinTTL(), info.particleMaxTTL()));
            this.emitterData.setUpdateRate(info.particleUpdateRate());
            this.emitterData.setOriginAlign(info.originAlign());
            this.emitterData.setOriginValign(info.originValign());
            this.activateOnInit = info.activateOnInit();
        }
    }

    public Emitter(EmitterData emitterData) {
        this();
        this.setEmitterData(emitterData);
    }

    public Emitter(Point2D origin, EmitterData emitterData) {
        this(origin);
        this.setEmitterData(emitterData);
    }

    public Emitter(double x, double y, EmitterData emitterData) {
        this(x, y);
        this.setEmitterData(emitterData);
    }

    public Emitter(double x, double y, String emitterXml) {
        this(x, y);
        this.setEmitterData(emitterXml);
    }

    public Emitter(Point2D origin, String emitterXml) {
        this(origin);
        this.setEmitterData(emitterXml);
    }

    public Emitter(double originX, double originY) {
        this(new Point2D.Double(originX, originY));
    }

    public Emitter(Point2D origin) {
        this();
        this.setLocation(origin);
    }

    public void activate() {
        if (this.activated) {
            return;
        }
        this.activated = true;
        this.activationTick = Game.time().now();
        Game.loop().attach(this);
    }

    public void addParticle(Particle particle) {
        if (this.isStopped()) {
            return;
        }
        this.particles.add(particle);
    }

    public void deactivate() {
        if (!this.activated) {
            return;
        }
        this.activated = false;
        this.getParticles().clear();
        this.aliveTime = 0L;
        this.activationTick = 0L;
        this.lastSpawn = 0L;
        Game.loop().detach(this);
    }

    public void delete() {
        this.deactivate();
        if (Game.world().environment() != null) {
            Game.world().environment().remove(this);
        }
    }

    @Override
    public long getAliveTime() {
        return this.aliveTime;
    }

    public EmitterData data() {
        return this.emitterData;
    }

    public Point2D getOrigin() {
        if (this.origin == null) {
            this.updateOrigin();
        }
        return this.origin;
    }

    protected void updateOrigin() {
        this.origin = new Point2D.Double(this.getX() + this.data().getOriginAlign().getValue(this.getWidth()), this.getY() + this.data().getOriginValign().getValue(this.getHeight()));
    }

    public IRenderable getRenderable(RenderType type) {
        if (type == RenderType.NONE) {
            return null;
        }
        return this.renderables.get((Object)type);
    }

    public List<Particle> getParticles() {
        return this.particles;
    }

    public boolean isActivateOnInit() {
        return this.activateOnInit;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public boolean isFinished() {
        return this.getTimeToLive() > 0 && this.timeToLiveReached();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public void onFinished(EmitterFinishedListener listener) {
        this.finishedListeners.add(listener);
    }

    public void removeFinishedListener(EmitterFinishedListener listener) {
        this.finishedListeners.remove(listener);
    }

    @Override
    public void render(Graphics2D g) {
        this.renderParticles(g, RenderType.NONE);
    }

    public void setEmitterData(EmitterData emitterData) {
        if (emitterData == null) {
            return;
        }
        this.emitterData = emitterData;
    }

    public void setEmitterData(String emitterXmlPath) {
        EmitterData loaded = EmitterLoader.load(emitterXmlPath);
        this.setEmitterData(loaded);
    }

    @Override
    public boolean timeToLiveReached() {
        return this.activated && this.getTimeToLive() > 0 && this.getAliveTime() >= (long)this.getTimeToLive();
    }

    public void togglePaused() {
        this.paused = !this.paused;
    }

    public void toggleStopped() {
        this.stopped = !this.stopped;
    }

    @Override
    public int getTimeToLive() {
        return this.data().getEmitterDuration();
    }

    @Override
    public void update() {
        if (this.isPaused()) {
            return;
        }
        if (this.isFinished()) {
            for (EmitterFinishedListener listener : this.finishedListeners) {
                listener.finished(this);
            }
            this.delete();
            return;
        }
        this.updateOrigin();
        float updateRatio = (float)this.data().getUpdateRate() / (float)Game.loop().getTickRate();
        for (Particle p : new ArrayList<Particle>(this.getParticles())) {
            if (this.particleCanBeRemoved(p)) {
                this.particles.remove(p);
                continue;
            }
            p.update(this.getOrigin(), updateRatio);
        }
        this.aliveTime = Game.time().since(this.activationTick);
        if (this.data().getSpawnRate() == 0 || Game.time().since(this.lastSpawn) >= (long)this.data().getSpawnRate()) {
            this.lastSpawn = Game.time().now();
            this.spawnParticle();
        }
    }

    protected boolean canTakeNewParticles() {
        return this.particles.size() < this.data().getMaxParticles();
    }

    protected Particle createNewParticle() {
        float width = (float)this.data().getParticleWidth().get();
        float height = (float)this.data().getParticleHeight().get();
        switch (this.data().getParticleType()) {
            case ELLIPSE: {
                return new EllipseParticle(width, height).init(this.data());
            }
            case TRIANGLE: {
                return new PolygonParticle(width, height, 3).init(this.data());
            }
            case DIAMOND: {
                return new PolygonParticle(width, height, 4).init(this.data());
            }
            case LINE: {
                return new LineParticle(width, height).init(this.data());
            }
            case TEXT: {
                String text = this.data().getTexts().isEmpty() ? "LITI" : Game.random().choose(this.data().getTexts());
                return new TextParticle(text).init(this.data());
            }
            case SPRITE: {
                Spritesheet sprite = Resources.spritesheets().get(this.data().getSpritesheet());
                if (sprite == null || sprite.getTotalNumberOfSprites() <= 0) {
                    return null;
                }
                return new SpriteParticle(sprite).setAnimateSprite(this.data().isAnimatingSprite()).setLoopSprite(this.data().isLoopingSprite()).init(this.data());
            }
        }
        return new RectangleParticle(width, height).init(this.data());
    }

    protected boolean particleCanBeRemoved(Particle particle) {
        return particle.timeToLiveReached();
    }

    protected void spawnParticle() {
        for (int i = 0; i < this.data().getSpawnAmount(); i = (int)((short)(i + 1))) {
            if (!this.canTakeNewParticles()) {
                return;
            }
            Particle part = this.createNewParticle();
            if (part == null) continue;
            this.addParticle(part);
        }
    }

    private void renderParticles(Graphics2D g, RenderType renderType) {
        if (Game.config().graphics().getGraphicQuality().getValue() < this.data().getRequiredQuality().getValue()) {
            return;
        }
        Rectangle2D viewport = Game.screens() != null && Game.world().camera() != null ? Game.world().camera().getViewport() : null;
        for (Particle particle : this.particles) {
            if ((particle.usesCustomRenderType() || renderType != RenderType.NONE) && (!particle.usesCustomRenderType() || particle.getCustomRenderType() != renderType) || viewport == null || !viewport.intersects(particle.getBoundingBox(this.getOrigin()))) continue;
            particle.render(g, this.getOrigin());
        }
    }

    @FunctionalInterface
    public static interface EmitterFinishedListener
    extends EventListener {
        public void finished(Emitter var1);
    }
}

