/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.graphics.ImageEffect;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.util.Imaging;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class RotationImageEffect
extends ImageEffect {
    private final float angle;

    public RotationImageEffect(int ttl, float angle) {
        super(ttl, "RotationImageEffect_" + angle);
        this.angle = angle;
    }

    @Override
    public BufferedImage apply(BufferedImage image) {
        if (image == null) {
            return null;
        }
        double radians = Math.toRadians(this.angle);
        int width = image.getWidth();
        int height = image.getHeight();
        int newWidth = (int)Math.abs((double)width * Math.cos(radians)) + (int)Math.abs((double)height * Math.sin(radians));
        int newHeight = (int)Math.abs((double)height * Math.cos(radians)) + (int)Math.abs((double)width * Math.sin(radians));
        BufferedImage rotatedImage = Imaging.getCompatibleImage(newWidth, newHeight);
        Graphics2D g = rotatedImage.createGraphics();
        ImageRenderer.renderRotated(g, image, new Point2D.Double(0.0, 0.0), this.getAngle());
        g.dispose();
        return rotatedImage;
    }

    public double getAngle() {
        return this.angle;
    }
}

