/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObject;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="template")
public class Blueprint
extends MapObject {
    public static final String TEMPLATE_FILE_EXTENSION = "tx";
    public static final String BLUEPRINT_FILE_EXTENSION = "xtx";
    @XmlElement(name="object")
    private List<MapObject> items = new ArrayList<MapObject>();
    @XmlTransient
    private boolean keepIds;

    public Blueprint() {
    }

    public Blueprint(String name, MapObject ... mapObjects) {
        this(name, false, mapObjects);
    }

    public Blueprint(String name, boolean keepIds, MapObject ... mapObjects) {
        this.keepIds = keepIds;
        this.setType(MapObjectType.AREA.toString());
        if (name != null && !name.isEmpty()) {
            this.setName(name);
        }
        Rectangle2D bounds = MapObject.getBounds(mapObjects);
        this.setWidth((float)bounds.getWidth());
        this.setHeight((float)bounds.getHeight());
        for (MapObject item : mapObjects) {
            MapObject newItem = new MapObject(item, this.keepIds());
            newItem.setX((float)((double)item.getX() - bounds.getX()));
            newItem.setY((float)((double)item.getY() - bounds.getY()));
            this.items.add(newItem);
        }
    }

    @XmlTransient
    public Iterable<MapObject> getItems() {
        return this.items;
    }

    public boolean keepIds() {
        return this.keepIds;
    }

    public List<IMapObject> build(Point2D location) {
        return this.build(Math.round((float)location.getX()), Math.round((float)location.getY()));
    }

    public List<IMapObject> build(float x, float y) {
        ArrayList<IMapObject> builtObjects = new ArrayList<IMapObject>();
        int baseId = Game.world().environment().getNextMapId();
        for (MapObject item : this.getItems()) {
            MapObject newObject = new MapObject(item, this.keepIds());
            if (!this.keepIds()) {
                newObject.setId(baseId);
                ++baseId;
            }
            newObject.setX(newObject.getX() + x);
            newObject.setY(newObject.getY() + y);
            builtObjects.add(newObject);
        }
        return builtObjects;
    }
}

