/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.Entity;
import de.gurkenlabs.litiengine.entities.EntityInfo;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.environment.tilemap.TmxType;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.function.Predicate;

@EntityInfo(renderType=RenderType.OVERLAY)
@TmxType(value=MapObjectType.LIGHTSOURCE)
public class LightSource
extends Entity
implements IRenderable {
    public static final String TOGGLE_MESSAGE = "toggle";
    public static final int DEFAULT_INTENSITY = 100;
    private static final float OBSTRUCTED_VISION_RADIUS = 200.0f;
    private static final float SHADOW_GRADIENT_SIZE = 100.0f;
    private static final float[] SHADOW_GRADIENT_FRACTIONS = new float[]{0.0f, 1.0f};
    private static final Color[] SHADOW_GRADIENT_COLORS = new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.3f), new Color(0.0f, 0.0f, 0.0f, 0.0f)};
    @TmxProperty(name="lightActive")
    private boolean activated;
    @TmxProperty(name="lightIntensity")
    private int intensity;
    @TmxProperty(name="lightShape")
    private Type lightShapeType;
    private Color color;
    private Shape lightShape;

    public LightSource(int intensity, Color lightColor, Type shapeType, boolean activated) {
        this.color = lightColor;
        this.intensity = intensity;
        this.lightShapeType = shapeType;
        this.activated = activated;
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        this.activated = true;
        this.updateAmbientLayers();
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.activated = false;
        this.updateAmbientLayers();
    }

    public Color getColor() {
        return this.color;
    }

    public RadialGradientPaint getGradientPaint() {
        Color[] transColors = new Color[]{this.getColor().brighter(), this.getColor(), new Color(this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue(), 0)};
        float[] colorFractions = new float[]{0.0f, 0.3f, 1.0f};
        return new RadialGradientPaint(this.getLightShape().getBounds2D(), colorFractions, transColors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
    }

    public int getIntensity() {
        return this.isActive() ? this.intensity : 0;
    }

    public Shape getLightShape() {
        return this.lightShape;
    }

    public Type getLightShapeType() {
        return this.lightShapeType;
    }

    public boolean isActive() {
        return this.activated;
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateAmbientLayers();
    }

    public void setIntensity(int intensity) {
        this.intensity = intensity;
        this.updateAmbientLayers();
    }

    public void setLightShapeType(Type shapeType) {
        this.lightShapeType = shapeType;
    }

    @Override
    public void setSize(double width, double height) {
        super.setSize(width, height);
        this.updateShape();
        this.updateAmbientLayers();
    }

    @Override
    public void setLocation(Point2D location) {
        super.setLocation(location);
        this.updateShape();
        this.updateAmbientLayers();
    }

    public void toggle() {
        this.activated = !this.activated;
        this.updateAmbientLayers();
    }

    @Override
    public String sendMessage(Object sender, String message) {
        if (message == null || message.isEmpty()) {
            return null;
        }
        if (message.equals(TOGGLE_MESSAGE)) {
            this.toggle();
            return Boolean.toString(this.isActive());
        }
        return null;
    }

    @Override
    public void render(Graphics2D graphic) {
        if (Game.config().graphics().renderDynamicShadows()) {
            this.renderShadows(graphic);
        }
    }

    private void updateAmbientLayers() {
        if (!this.isLoaded()) {
            return;
        }
        if (Game.world().environment() != null && Game.world().environment().getAmbientLight() != null) {
            Game.world().environment().getAmbientLight().updateSection(this.getBoundingBox());
        }
        if (Game.world().environment() != null && Game.world().environment().getStaticShadowLayer() != null) {
            Game.world().environment().getStaticShadowLayer().updateSection(this.getBoundingBox());
        }
    }

    private void updateShape() {
        this.lightShape = this.getLightShapeType() == Type.RECTANGLE ? new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight()) : new Ellipse2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    private void renderShadows(Graphics2D graphic) {
        if (Game.world().environment().getCombatEntities().stream().noneMatch(LightSource.isInRange(this.getCenter()))) {
            return;
        }
        RadialGradientPaint gradientPaint = new RadialGradientPaint(Game.world().camera().getViewportDimensionCenter(this), 100.0f, SHADOW_GRADIENT_FRACTIONS, SHADOW_GRADIENT_COLORS);
        Paint oldPaint = graphic.getPaint();
        graphic.setPaint(gradientPaint);
        for (ICombatEntity mob : Game.world().environment().getCombatEntities()) {
            if (mob.isDead() || !LightSource.isInRange(this.getCenter()).test(mob)) continue;
            Area obstructedVision = LightSource.getObstructedVisionArea(mob, Game.world().camera().getViewportDimensionCenter(this));
            ShapeRenderer.render(graphic, obstructedVision);
        }
        graphic.setPaint(oldPaint);
    }

    private static Predicate<? super IEntity> isInRange(Point2D center) {
        return mob -> new Ellipse2D.Double(center.getX() - 100.0, center.getY() - 100.0, 200.0, 200.0).contains(mob.getCenter());
    }

    private static Area getObstructedVisionArea(IEntity entity, Point2D center) {
        Polygon shadowPolygon = new Polygon();
        Ellipse2D shadowEllipse = LightSource.getShadowEllipse(entity);
        Rectangle2D bounds = shadowEllipse.getBounds2D();
        float r = (float)bounds.getWidth() / 2.0f;
        float ry = (float)bounds.getHeight() / 2.0f;
        Point2D relativeCenter = Game.world().camera().getViewportLocation(new Point((int)(bounds.getX() + (double)r), (int)(bounds.getY() + (double)ry)));
        double cx = relativeCenter.getX();
        double cy = relativeCenter.getY();
        double dx = cx - center.getX();
        double dy = cy - center.getY();
        double distSq = dx * dx + dy * dy;
        float len = (float)Math.sqrt(distSq);
        double nx = dx;
        double ny = dy;
        if (len != 0.0f) {
            nx /= (double)len;
            ny /= (double)len;
        }
        double px = -ny;
        double py = nx;
        Point2D.Double pointA = new Point2D.Double(cx - px * (double)r, cy - py * (double)ry);
        Point2D.Double pointB = new Point2D.Double(cx + px * (double)r, cy + py * (double)ry);
        Point2D pointC = GeometricUtilities.project(center, pointA, 200.0);
        Point2D pointD = GeometricUtilities.project(center, pointB, 200.0);
        shadowPolygon.reset();
        shadowPolygon.addPoint((int)pointA.getX(), (int)pointA.getY());
        shadowPolygon.addPoint((int)pointB.getX(), (int)pointB.getY());
        shadowPolygon.addPoint((int)pointD.getX(), (int)pointD.getY());
        shadowPolygon.addPoint((int)pointC.getX(), (int)pointC.getY());
        Point2D shadowRenderLocation = Game.world().camera().getViewportLocation(new Point2D.Double(shadowEllipse.getX(), shadowEllipse.getY()));
        Ellipse2D.Double relativeEllipse = new Ellipse2D.Double(shadowRenderLocation.getX(), shadowRenderLocation.getY(), shadowEllipse.getWidth(), shadowEllipse.getHeight());
        Area ellipseArea = new Area(relativeEllipse);
        Area shadowArea = new Area(shadowPolygon);
        shadowArea.add(ellipseArea);
        return shadowArea;
    }

    private static Ellipse2D getShadowEllipse(IEntity entity) {
        int shadowHeight = (int)(entity.getHeight() / 4.0);
        int shadowWidth = (int)(entity.getWidth() / 3.0);
        int yOffset = (int)entity.getHeight();
        double x = entity.getX() + (entity.getWidth() - (double)shadowWidth) / 2.0;
        double y = entity.getY() + (double)yOffset - (double)shadowHeight / 2.0;
        return new Ellipse2D.Double(x, y, shadowWidth, shadowHeight);
    }

    public static enum Type {
        ELLIPSE,
        RECTANGLE;

    }
}

