/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities.targeting;

import de.gurkenlabs.litiengine.abilities.targeting.CustomTargetingStrategy;
import de.gurkenlabs.litiengine.abilities.targeting.EnemyTargetingStrategy;
import de.gurkenlabs.litiengine.abilities.targeting.ExecutingEntityTargetingStrategy;
import de.gurkenlabs.litiengine.abilities.targeting.FriendlyTargetingStrategy;
import de.gurkenlabs.litiengine.entities.EntityDistanceComparator;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import java.awt.Shape;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public abstract class TargetingStrategy {
    private boolean multiTarget;
    private boolean prioritizeByDistance;
    private BiPredicate<ICombatEntity, ICombatEntity> additionalCondition;
    private Comparator<IEntity> customTargetPriorityComparator;

    protected TargetingStrategy(boolean multiTarget, boolean sortByDistance) {
        this.multiTarget = multiTarget;
        this.prioritizeByDistance = sortByDistance;
    }

    public Collection<ICombatEntity> findTargets(Shape impactArea, ICombatEntity executor) {
        List entities = this.findTargetsInternal(impactArea, executor);
        if (this.additionalCondition != null) {
            entities = entities.stream().filter(e -> this.additionalCondition.test(executor, (ICombatEntity)e)).collect(Collectors.toList());
        }
        if (entities.isEmpty()) {
            return entities;
        }
        if (executor != null) {
            EntityDistanceComparator comparator = null;
            if (this.customTargetPriorityComparator != null) {
                comparator = this.customTargetPriorityComparator;
            } else if (this.prioritizeByDistance) {
                comparator = new EntityDistanceComparator(executor);
            }
            if (comparator != null) {
                List list;
                entities = list = entities.stream().sorted(comparator).collect(Collectors.toList());
            }
        }
        if (this.isMultiTarget()) {
            return entities;
        }
        return List.of((ICombatEntity)entities.stream().findFirst().get());
    }

    protected abstract Collection<ICombatEntity> findTargetsInternal(Shape var1, ICombatEntity var2);

    public boolean isMultiTarget() {
        return this.multiTarget;
    }

    public void setMultiTarget(boolean multiTarget) {
        this.multiTarget = multiTarget;
    }

    public boolean prioritizeByDistance() {
        return this.prioritizeByDistance;
    }

    public void setPrioritizeByDistance(boolean prioritizeByDistance) {
        this.prioritizeByDistance = prioritizeByDistance;
    }

    public void setCustomTargetPriorityComparator(Comparator<IEntity> customTargetPriorityComparator) {
        this.customTargetPriorityComparator = customTargetPriorityComparator;
    }

    public TargetingStrategy withCondition(BiPredicate<ICombatEntity, ICombatEntity> customCondition) {
        this.additionalCondition = customCondition;
        return this;
    }

    public static TargetingStrategy enemies() {
        return new EnemyTargetingStrategy(true, false, false);
    }

    public static TargetingStrategy executingEntity() {
        return new ExecutingEntityTargetingStrategy();
    }

    public static TargetingStrategy friendly() {
        return new FriendlyTargetingStrategy(true, false, false);
    }

    public static TargetingStrategy friendlyDead() {
        return new FriendlyTargetingStrategy(true, false, true);
    }

    public static TargetingStrategy custom(BiPredicate<ICombatEntity, ICombatEntity> customPredicate) {
        return new CustomTargetingStrategy(customPredicate, true, false);
    }

    public static TargetingStrategy none() {
        return TargetingStrategy.custom((e, f) -> false);
    }
}

