/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.physics.Collision;
import de.gurkenlabs.litiengine.physics.CollisionEvent;
import de.gurkenlabs.litiengine.physics.RaycastHit;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class PhysicsEngine
implements IUpdateable {
    private Rectangle2D environmentBounds;
    private final Map<Collision, List<ICollisionEntity>> collisionEntities = new ConcurrentHashMap<Collision, List<ICollisionEntity>>();
    private final Map<Collision, List<Rectangle2D>> collisionBoxes = new ConcurrentHashMap<Collision, List<Rectangle2D>>();

    public PhysicsEngine() {
        if (Game.physics() != null) {
            throw new UnsupportedOperationException("Never initialize a PhysicsEngine manually. Use Game.physics() instead.");
        }
        this.collisionEntities.put(Collision.DYNAMIC, new CopyOnWriteArrayList());
        this.collisionEntities.put(Collision.STATIC, new CopyOnWriteArrayList());
        this.collisionBoxes.put(Collision.DYNAMIC, new CopyOnWriteArrayList());
        this.collisionBoxes.put(Collision.STATIC, new CopyOnWriteArrayList());
    }

    public void add(ICollisionEntity entity) {
        if (entity.getCollisionType() == null) {
            return;
        }
        this.collisionEntities.get((Object)entity.getCollisionType()).add(entity);
    }

    public void remove(ICollisionEntity entity) {
        if (entity.getCollisionType() == null) {
            return;
        }
        this.collisionEntities.get((Object)entity.getCollisionType()).remove(entity);
    }

    public void clear() {
        for (Collision type : Collision.values()) {
            if (type == Collision.NONE || type == Collision.ANY) continue;
            this.collisionEntities.get((Object)type).clear();
            this.collisionBoxes.get((Object)type).clear();
        }
        this.setBounds(null);
    }

    public Collection<Rectangle2D> getCollisionBoxes() {
        return this.getCollisionBoxes(Collision.ANY);
    }

    public Collection<Rectangle2D> getCollisionBoxes(Collision type) {
        switch (type) {
            case NONE: {
                return Collections.emptySet();
            }
            case DYNAMIC: 
            case STATIC: {
                return Collections.unmodifiableCollection((Collection)this.collisionBoxes.get((Object)type));
            }
            case ANY: {
                return Stream.concat(this.collisionBoxes.get((Object)Collision.DYNAMIC).stream(), this.collisionBoxes.get((Object)Collision.STATIC).stream()).toList();
            }
        }
        throw new IllegalStateException("Unexpected collision value: " + String.valueOf((Object)type));
    }

    public Collection<ICollisionEntity> getCollisionEntities() {
        return this.getCollisionEntities(Collision.ANY);
    }

    public Collection<ICollisionEntity> getCollisionEntities(Collision type) {
        switch (type) {
            case NONE: {
                return Collections.emptySet();
            }
            case DYNAMIC: 
            case STATIC: {
                return Collections.unmodifiableCollection((Collection)this.collisionEntities.get((Object)type));
            }
            case ANY: {
                return Stream.concat(this.collisionEntities.get((Object)Collision.DYNAMIC).stream(), this.collisionEntities.get((Object)Collision.STATIC).stream()).toList();
            }
        }
        throw new IllegalStateException("Unexpected collision value: " + String.valueOf((Object)type));
    }

    public Rectangle2D getBounds() {
        return this.environmentBounds;
    }

    public void setBounds(Rectangle2D environmentBounds) {
        this.environmentBounds = environmentBounds;
    }

    public boolean collides(Line2D line) {
        return this.collides(line, Collision.ANY, null);
    }

    public boolean collides(Line2D line, Collision collision) {
        return this.collides(line, collision, null);
    }

    public boolean collides(Line2D line, ICollisionEntity entity) {
        return this.collides(line, Collision.ANY, entity);
    }

    public boolean collides(Line2D line, Collision collision, ICollisionEntity entity) {
        return this.collides(entity, collision, (ICollisionEntity e) -> GeometricUtilities.getIntersectionPoint(line, e.getCollisionBox()) != null);
    }

    public boolean collides(Rectangle2D rect) {
        return this.collides(rect, Collision.ANY);
    }

    public boolean collides(Rectangle2D rect, ICollisionEntity entity) {
        return this.collides(rect, Collision.ANY, entity);
    }

    public boolean collides(Rectangle2D rect, Collision collision) {
        return this.collides(rect, collision, null);
    }

    public boolean collides(Rectangle2D rect, Collision collision, ICollisionEntity entity) {
        if (this.environmentBounds != null && !this.environmentBounds.intersects(rect)) {
            return true;
        }
        return this.collides(entity, collision, (ICollisionEntity otherEntity) -> GeometricUtilities.intersects(otherEntity.getCollisionBox(), rect));
    }

    public boolean collides(Point2D location) {
        return this.collides(location, Collision.ANY);
    }

    public boolean collides(Point2D location, Collision collision) {
        return this.collides(location, collision, null);
    }

    public boolean collides(Point2D location, ICollisionEntity entity) {
        return this.collides(location, Collision.ANY, entity);
    }

    public boolean collides(Point2D location, Collision collision, ICollisionEntity entity) {
        if (this.environmentBounds != null && !this.environmentBounds.contains(location)) {
            return true;
        }
        return this.collides(entity, collision, (ICollisionEntity otherEntity) -> otherEntity.getCollisionBox().contains(location));
    }

    public boolean collides(double x, double y) {
        return this.collides(new Point2D.Double(x, y));
    }

    public boolean collides(double x, double y, Collision collision) {
        return this.collides((Point2D)new Point2D.Double(x, y), collision);
    }

    public boolean collides(double x, double y, ICollisionEntity entity) {
        return this.collides((Point2D)new Point2D.Double(x, y), entity);
    }

    public boolean collides(ICollisionEntity entity) {
        return this.collides(entity, Collision.ANY);
    }

    public boolean collides(ICollisionEntity entity, Collision collision) {
        return this.collides(entity.getCollisionBox(), collision, entity);
    }

    public RaycastHit raycast(Point2D start, double angle) {
        double diameter = GeometricUtilities.getDiagonal(this.environmentBounds);
        return this.raycast(start, GeometricUtilities.project(start, angle, diameter));
    }

    public RaycastHit raycast(Point2D start, Point2D target) {
        return this.raycast(start, target, Collision.ANY);
    }

    public RaycastHit raycast(Point2D start, Point2D target, Collision collision) {
        Line2D.Double line = new Line2D.Double(start.getX(), start.getY(), target.getX(), target.getY());
        return this.raycast(line, collision, null);
    }

    public RaycastHit raycast(Line2D line) {
        return this.raycast(line, Collision.ANY, null);
    }

    public RaycastHit raycast(Line2D line, Collision collision) {
        return this.raycast(line, collision, null);
    }

    public RaycastHit raycast(Line2D line, ICollisionEntity entity) {
        return this.raycast(line, Collision.ANY, entity);
    }

    public RaycastHit raycast(Line2D line, Collision collision, ICollisionEntity entity) {
        Point2D.Double rayCastSource = new Point2D.Double(line.getX1(), line.getY1());
        for (ICollisionEntity collisionEntity : this.getCollisionEntities(collision)) {
            if (!PhysicsEngine.canCollide(entity, collisionEntity) || collisionEntity == entity || !collisionEntity.getCollisionBox().intersectsLine(line)) continue;
            double closestDist = -1.0;
            Point2D closestPoint = null;
            for (Point2D intersection : GeometricUtilities.getIntersectionPoints(line, collisionEntity.getCollisionBox())) {
                double dist = intersection.distance(rayCastSource);
                if (closestPoint != null && !(dist < closestDist)) continue;
                closestPoint = intersection;
                closestDist = dist;
            }
            return new RaycastHit(closestPoint, collisionEntity, closestDist);
        }
        return null;
    }

    public boolean move(IMobileEntity entity, double angle, double distance) {
        Point2D newLocation = GeometricUtilities.project(entity.getLocation(), angle, distance);
        return this.move(entity, newLocation);
    }

    public boolean move(IMobileEntity entity, Direction direction, double distance) {
        return this.move(entity, direction.toAngle(), distance);
    }

    public boolean move(IMobileEntity entity, double x, double y, float distance) {
        return this.move(entity, (Point2D)new Point2D.Double(x, y), distance);
    }

    public boolean move(IMobileEntity entity, float distance) {
        return this.move(entity, entity.getAngle(), (double)distance);
    }

    public boolean move(IMobileEntity entity, Point2D target, boolean turnTowardsTarget) {
        if (turnTowardsTarget) {
            entity.setAngle((float)GeometricUtilities.calcRotationAngleInDegrees(entity.getLocation(), target));
        }
        if (!this.isInMap(entity.getCollisionBox(target))) {
            target = this.clamptoMap(entity, target);
        }
        if (!entity.hasCollision()) {
            entity.setLocation(target);
            return true;
        }
        if (this.resolveCollisionForNewLocation(entity, target)) {
            return false;
        }
        if (this.resolveCollisionForRaycastToNewLocation(entity, target)) {
            return false;
        }
        if (entity.getLocation().equals(target)) {
            return false;
        }
        entity.setLocation(target);
        return true;
    }

    public boolean move(IMobileEntity entity, Point2D target) {
        return this.move(entity, target, entity.turnOnMove());
    }

    public boolean move(IMobileEntity entity, Point2D target, float distance) {
        Point2D newLocation = GeometricUtilities.project(entity.getLocation(), target, (double)distance);
        return this.move(entity, newLocation);
    }

    @Override
    public void update() {
        for (Collision type : Collision.values()) {
            if (type == Collision.NONE || type == Collision.ANY) continue;
            this.collisionBoxes.get((Object)type).clear();
            this.collisionBoxes.get((Object)type).addAll(this.collisionEntities.get((Object)type).stream().map(ICollisionEntity::getCollisionBox).toList());
        }
    }

    private static boolean canCollide(ICollisionEntity entity, ICollisionEntity otherEntity) {
        if (otherEntity == null || !otherEntity.hasCollision()) {
            return false;
        }
        if (entity == null) {
            return true;
        }
        if (otherEntity.equals(entity)) {
            return false;
        }
        return entity.canCollideWith(otherEntity);
    }

    private Intersection getIntersection(ICollisionEntity entity, Rectangle2D rect) {
        Intersection result = null;
        for (ICollisionEntity otherEntity : this.getCollisionEntities()) {
            if (!PhysicsEngine.canCollide(entity, otherEntity) || !GeometricUtilities.intersects(otherEntity.getCollisionBox(), rect)) continue;
            Rectangle2D intersection = otherEntity.getCollisionBox().createIntersection(rect);
            if (result != null) {
                result = new Intersection(intersection.createUnion(result), ArrayUtilities.append(result.involvedEntities, otherEntity));
                continue;
            }
            result = new Intersection(intersection, otherEntity);
        }
        return result;
    }

    private boolean collides(ICollisionEntity entity, Collision type, Predicate<ICollisionEntity> check) {
        for (ICollisionEntity otherEntity : this.getCollisionEntities(type)) {
            if (!PhysicsEngine.canCollide(entity, otherEntity) || entity == otherEntity || !check.test(otherEntity)) continue;
            return true;
        }
        return false;
    }

    private boolean isInMap(Shape collisionBox) {
        if (this.environmentBounds == null) {
            return true;
        }
        return this.environmentBounds.contains(collisionBox.getBounds());
    }

    private Point2D resolveCollision(ICollisionEntity entity, Point2D targetLocation) {
        Point2D.Double resolvedLocation = new Point2D.Double(targetLocation.getX(), entity.getY());
        Rectangle2D targetCollisionBoxX = entity.getCollisionBox(resolvedLocation);
        Intersection intersectionX = this.getIntersection(entity, targetCollisionBoxX);
        if (intersectionX != null) {
            if (entity.getCollisionBox().getX() < targetCollisionBoxX.getX()) {
                ((Point2D)resolvedLocation).setLocation(Math.max(entity.getX(), ((Point2D)resolvedLocation).getX() - intersectionX.getWidth()), ((Point2D)resolvedLocation).getY());
            } else {
                ((Point2D)resolvedLocation).setLocation(Math.min(entity.getX(), ((Point2D)resolvedLocation).getX() + intersectionX.getWidth()), ((Point2D)resolvedLocation).getY());
            }
        }
        ((Point2D)resolvedLocation).setLocation(((Point2D)resolvedLocation).getX(), targetLocation.getY());
        Rectangle2D targetCollisionBoxY = entity.getCollisionBox(resolvedLocation);
        Intersection intersectionY = this.getIntersection(entity, targetCollisionBoxY);
        if (intersectionY != null) {
            if (entity.getCollisionBox().getY() < targetCollisionBoxY.getY()) {
                ((Point2D)resolvedLocation).setLocation(((Point2D)resolvedLocation).getX(), Math.max(entity.getY(), ((Point2D)resolvedLocation).getY() - intersectionY.getHeight()));
            } else {
                ((Point2D)resolvedLocation).setLocation(((Point2D)resolvedLocation).getX(), Math.min(entity.getY(), ((Point2D)resolvedLocation).getY() + intersectionY.getHeight()));
            }
        }
        PhysicsEngine.fireCollisionEvents(entity, intersectionX, intersectionY);
        return resolvedLocation;
    }

    private Point2D clamptoMap(IMobileEntity entity, Point2D newLocation) {
        double collisionLocationX = entity.getCollisionBoxAlign().getLocation(entity.getWidth(), entity.getCollisionBoxWidth());
        double leftBoundX = this.getBounds().getMinX() - collisionLocationX;
        double deltaX = entity.getWidth() - entity.getCollisionBoxWidth() - collisionLocationX;
        double rightBoundX = this.getBounds().getMaxX() - entity.getWidth() + deltaX;
        double collisionLocationY = entity.getCollisionBoxValign().getLocation(entity.getHeight(), entity.getCollisionBoxHeight());
        double topBoundY = this.getBounds().getMinY() - collisionLocationY;
        double deltaY = entity.getHeight() - entity.getCollisionBoxHeight() - collisionLocationY;
        double buttomBoundY = this.getBounds().getMaxY() - entity.getHeight() + deltaY;
        double x = Math.clamp(newLocation.getX(), leftBoundX, rightBoundX);
        double y = Math.clamp(newLocation.getY(), topBoundY, buttomBoundY);
        return new Point2D.Double(x, y);
    }

    private boolean resolveCollisionForNewLocation(ICollisionEntity entity, Point2D location) {
        if (this.collides(entity.getCollisionBox(location), entity)) {
            Point2D resolvedLocation = this.resolveCollision(entity, location);
            entity.setLocation(resolvedLocation);
            return true;
        }
        return false;
    }

    private boolean resolveCollisionForRaycastToNewLocation(ICollisionEntity entity, Point2D newLocation) {
        Line2D.Double line = new Line2D.Double(entity.getCollisionBox().getCenterX(), entity.getCollisionBox().getCenterY(), entity.getCollisionBox(newLocation).getCenterX(), entity.getCollisionBox(newLocation).getCenterY());
        return this.collides(line, Collision.ANY, entity);
    }

    private static void fireCollisionEvents(ICollisionEntity collider, Intersection ... intersections) {
        ICollisionEntity[] involvedEntities = null;
        for (Intersection inter : intersections) {
            if (inter == null) continue;
            involvedEntities = involvedEntities == null ? inter.involvedEntities : ArrayUtilities.distinct(involvedEntities, inter.involvedEntities);
        }
        CollisionEvent event = new CollisionEvent(collider, involvedEntities);
        collider.fireCollisionEvent(event);
        CollisionEvent colliderEvent = new CollisionEvent(collider, new ICollisionEntity[0]);
        for (ICollisionEntity involved : Objects.requireNonNull(involvedEntities)) {
            involved.fireCollisionEvent(colliderEvent);
        }
    }

    private static class Intersection
    extends Rectangle2D.Double {
        private final transient ICollisionEntity[] involvedEntities;

        public Intersection(Rectangle2D rect, ICollisionEntity ... entities) {
            super(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
            this.involvedEntities = entities;
        }
    }
}

