/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.input;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.GameListener;
import de.gurkenlabs.litiengine.input.GamepadManager;
import de.gurkenlabs.litiengine.input.IKeyboard;
import de.gurkenlabs.litiengine.input.IMouse;
import de.gurkenlabs.litiengine.input.Keyboard;
import de.gurkenlabs.litiengine.input.Mouse;
import java.awt.AWTException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Input {
    private static final Logger log = Logger.getLogger(Input.class.getName());
    private static GamepadManager gamePadManager;
    private static IKeyboard keyboard;
    private static IMouse mouse;

    private Input() {
        throw new UnsupportedOperationException();
    }

    public static GamepadManager gamepads() {
        if (!Game.config().input().isGamepadSupport()) {
            log.log(Level.SEVERE, "Cannot access gamepads because gamepad support is disabled in the configuration.");
        }
        return gamePadManager;
    }

    public static IKeyboard keyboard() {
        return keyboard;
    }

    public static IMouse mouse() {
        return mouse;
    }

    public static final class InputGameAdapter
    implements GameListener {
        @Override
        public void terminated() {
            if (gamePadManager != null) {
                gamePadManager.terminate();
            }
        }

        @Override
        public void initialized(String ... args) {
            InputGameAdapter.init();
        }

        @Override
        public void started() {
            if (gamePadManager != null) {
                gamePadManager.start();
            }
        }

        private static void init() {
            try {
                keyboard = new Keyboard();
                Mouse m = new Mouse();
                if (!Game.isInNoGUIMode()) {
                    Game.window().getRenderComponent().addMouseListener(m);
                    Game.window().getRenderComponent().addMouseMotionListener(m);
                    Game.window().getRenderComponent().addMouseWheelListener(m);
                }
                mouse = m;
                if (Game.config().input().isGamepadSupport()) {
                    gamePadManager = new GamepadManager();
                }
            }
            catch (AWTException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

