/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import de.gurkenlabs.litiengine.gui.FontIcon;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.gui.Slider;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class VerticalSlider
extends Slider {
    public static final FontIcon ARROW_DOWN = new FontIcon(ICON_FONT, "\ue804");
    public static final FontIcon ARROW_UP = new FontIcon(ICON_FONT, "\ue807");

    public VerticalSlider(double x, double y, double width, double height, float minValue, float maxValue, float stepSize) {
        super(x, y, width, height, minValue, maxValue, stepSize);
    }

    @Override
    public Point2D getRelativeSliderLocation() {
        try {
            float frac = Math.clamp((this.getCurrentValue() - this.getMinValue()) / (this.getMaxValue() - this.getMinValue()), 0.0f, 1.0f);
            int currentStep = (int)(frac * (float)(this.getSteps() - 1));
            return new Point2D.Double(this.getX(), this.getY() + (double)currentStep * this.getSliderComponent().getHeight());
        }
        catch (Exception e) {
            return new Point2D.Double(0.0, 0.0);
        }
    }

    @Override
    protected void updateSliderDimensions() {
        this.getSliderComponent().setHeight(this.getHeight() / (double)this.getSteps());
    }

    @Override
    protected void renderBar(Graphics2D g) {
        ShapeRenderer.renderOutline(g, (Shape)new Line2D.Double(this.getX() + this.getWidth() / 2.0, this.getY(), this.getX() + this.getWidth() / 2.0, this.getY() + this.getHeight()), (float)(this.getWidth() / 10.0) * this.getTickSize());
    }

    @Override
    protected void renderTicks(Graphics2D g) {
        for (int i = 1; i < this.getSteps(); ++i) {
            ShapeRenderer.renderOutline(g, (Shape)new Line2D.Double(this.getX() + this.getWidth() / 2.0 - (double)this.getTickSize() * this.getWidth() / 2.0, this.getY() + (double)i * this.getHeight() / (double)this.getSteps(), this.getX() + this.getWidth() / 2.0 + (double)this.getTickSize() * this.getWidth() / 2.0, this.getY() + (double)i * this.getHeight() / (double)this.getSteps()), (float)(this.getWidth() / 200.0 * (double)this.getTickSize()));
        }
    }

    @Override
    protected float getRelativeMouseValue() {
        return (float)((Input.mouse().getLocation().getY() - this.getY()) / this.getHeight());
    }

    @Override
    protected void initializeComponents() {
        super.initializeComponents();
        this.setButton1(new ImageComponent(this.getX(), this.getY() - this.getWidth(), this.getWidth(), this.getWidth(), this.getButtonSpritesheet(), ARROW_UP.getText(), null));
        this.getButton1().setFont(ARROW_UP.getFont());
        this.setButton2(new ImageComponent(this.getX(), this.getY() + this.getHeight(), this.getWidth(), this.getWidth(), this.getButtonSpritesheet(), ARROW_DOWN.getText(), null));
        this.getButton2().setFont(ARROW_DOWN.getFont());
        this.setSliderComponent(new ImageComponent(this.getRelativeSliderLocation().getX(), this.getRelativeSliderLocation().getY(), this.getWidth(), this.getWidth() * 2.0, this.getSliderSpritesheet(), "", null));
    }
}

